# Configuración de QZ Tray con Firma Digital

## 📋 Requisitos Previos

1. **QZ Tray instalado** en el equipo del usuario
2. **Certificados generados** usando QZ Tray (ver instrucciones en https://qz.io/docs/2.2/certificates/)

## 🔐 Archivos Necesarios

### 1. Llave Privada (Llave Maestra Secreta)
- **Ubicación**: `storage/app/private/private-key-pkcs8.pem`
- **Formato**: PKCS#8 (formato PEM)
- **Seguridad**: ⚠️ NUNCA debe estar en la carpeta `public`, solo en `storage/app/private`
- **Permisos**: Solo el servidor debe poder leerlo (chmod 600 recomendado)

### 2. Certificado Público (Cerradura)
- **Ubicación**: `public/digital-certificate.txt`
- **Formato**: Texto plano con el certificado
- **Seguridad**: ✅ Puede ser público (es la "cerradura")

## 📝 Pasos de Configuración

### Paso 1: Generar Certificados con QZ Tray

1. Abre QZ Tray en tu equipo
2. Ve a la configuración de certificados
3. Genera un nuevo par de certificados
4. Exporta:
   - **Llave privada** en formato PKCS#8 → `private-key-pkcs8.pem`
   - **Certificado público** → `digital-certificate.txt`

### Paso 2: Colocar Archivos en el Servidor

#### Llave Privada:
```bash
# Crear directorio si no existe
mkdir -p storage/app/private

# Copiar la llave privada
cp /ruta/a/tu/private-key-pkcs8.pem storage/app/private/

# Asegurar permisos (solo lectura para el servidor)
chmod 600 storage/app/private/private-key-pkcs8.pem
```

#### Certificado Público:
```bash
# Copiar el certificado público
cp /ruta/a/tu/digital-certificate.txt public/
```

### Paso 3: Verificar Configuración

1. Verifica que los archivos existan:
   - `storage/app/private/private-key-pkcs8.pem` ✅
   - `public/digital-certificate.txt` ✅

2. Prueba la conexión desde la aplicación:
   - Ve a la sección de Scanner o Reetiquetado
   - Intenta conectar con QZ Tray
   - Debería funcionar sin errores de certificado

## 🔧 Funcionamiento

### Flujo de Firma:

1. **Frontend (JavaScript)**:
   - Carga el certificado público desde `/digital-certificate.txt`
   - Configura QZ Tray para usar firma personalizada

2. **Conexión**:
   - Cuando QZ Tray necesita firmar datos, llama a `/api/qz/sign`
   - Envía los datos a firmar en el body de la petición

3. **Backend (Laravel)**:
   - El endpoint `/api/qz/sign` recibe los datos
   - Lee la llave privada desde `storage/app/private/private-key-pkcs8.pem`
   - Firma los datos usando `openssl_sign` con algoritmo SHA-512
   - Devuelve la firma en base64

4. **Frontend**:
   - Recibe la firma y la convierte a ArrayBuffer
   - QZ Tray usa la firma para autenticar la conexión

## 🛠️ Solución de Problemas

### Error: "Llave privada no encontrada"
- Verifica que el archivo existe en `storage/app/private/private-key-pkcs8.pem`
- Verifica los permisos del archivo

### Error: "No se pudo cargar el certificado público"
- Verifica que el archivo existe en `public/digital-certificate.txt`
- Verifica que el archivo es accesible desde el navegador

### Error: "Error al firmar los datos"
- Verifica que la llave privada es válida (formato PKCS#8)
- Verifica que OpenSSL está habilitado en PHP
- Revisa los logs en `storage/logs/laravel.log`

## 📚 Referencias

- Documentación QZ Tray: https://qz.io/docs/
- Certificados QZ Tray: https://qz.io/docs/2.2/certificates/

