<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class InventorySampleExport implements FromCollection, WithHeadings, WithStyles
{
    /**
     * @return \Illuminate\Support\Collection
     */
    /**
     * @return \Illuminate\Support\Collection
     */
    public function collection()
    {
        // Retornar datos de ejemplo
        return collect([
            [
                'TEST001',
                '5',
                'CAJA-001',
                'TEST001-EAN',
                'TEXTIL',
                'FAMILIA_U_1',
                'DETALLE_U_1',
                'MUJER',
                'CADENA 1',
                'CHINA',
                '10.50',
                '0.2',
                '2024',
                'ALGODON',
                'CONT-001',
                'RECEPCION',
                '2024',
                'Nota ej',
            ],
            [
                'TEST002',
                '2',
                'CAJA-001',
                'TEST002-EAN',
                'CALZADO',
                'FAMILIA_U_2',
                'DETALLE_U_2',
                'HOMBRE',
                'CADENA 1',
                'CHINA',
                '25.00',
                '0.5',
                '2024',
                'CUERO',
                'CONT-001',
                'RECEPCION',
                '2024',
                '',
            ],
            [
                'TEST003',
                '10',
                'CAJA-002',
                'TEST003-EAN',
                'ACCESORIOS',
                'FAMILIA_U_3',
                'DETALLE_U_3',
                'NIÑO',
                'CADENA 2',
                'VIETNAM',
                '50.00',
                '1.0',
                '2024',
                'PLASTICO',
                'CONT-002',
                'P1-02',
                '2024',
                'Sin caja fisica',
            ],
        ]);
    }

    /**
     * @return array
     */
    public function headings(): array
    {
        return [
            'mocaco',
            'cantidad_unidades',
            'n_carton',
            'full_barcode',
            'CATEG',
            'familia_usuario',
            'detail_usuario',
            'seccion',
            'cadena',
            'mercado_origen_articulo',
            'precio_pvp_maximo_temporada',
            'peso_unitario',
            'campana',
            'composition',
            'contenedor',
            'ubicacion',
            'season_int',
            'notes',
        ];
    }

    /**
     * @param Worksheet $sheet
     * @return array
     */
    public function styles(Worksheet $sheet)
    {
        return [
            // Estilo para la fila de encabezados
            1 => ['font' => ['bold' => true]],
        ];
    }
}
