<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use Illuminate\Support\Collection;

class ReservationTemplateExport implements FromCollection, WithHeadings, WithStyles
{
    /**
     * Return empty collection (template only)
     */
    public function collection()
    {
        // Return a few example rows
        return collect([
            ['CAJA001', 'X'],
            ['CAJA002', '1'],
            ['CAJA003', ''],
        ]);
    }

    /**
     * Define headings
     */
    public function headings(): array
    {
        return [
            'BOX_NUMBER',
            'SELECCIONAR', // X or 1 to select
        ];
    }

    /**
     * Apply styles
     */
    public function styles(Worksheet $sheet)
    {
        return [
            1 => ['font' => ['bold' => true]],
        ];
    }
}
