<?php

namespace App\Exports;

use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithTitle;

class TheoreticalArticleSampleExport implements FromCollection, WithHeadings, WithTitle
{
    public function collection(): Collection
    {
        // Fila de ejemplo con valores de referencia
        return new Collection([
            [
                'mocaco' => '7638309807',
                'cantidad' => 364,
                'campana' => 'W2025',
                'seccion' => 'WOMAN',
                'familia_ar' => 'BIB OVERA',
                'cadena' => 'PB',
                'mercado' => 'TURKEY',
                'precio_pv' => 35.99,
                'partida_ar' => '6211.42.90',
                'compositi' => '99% COTT',
                'peso_unit' => 0.233,
                'grupo_ara' => 'WOVEN',
                'season_in' => '',
                'categoria' => '',
                'famillie_u' => '',
                'detail_usu' => '',
                'notes' => '',
            ],
        ]);
    }

    public function headings(): array
    {
        // Usar nombres abreviados que coinciden con el formato común del Excel
        return [
            'mocaco',
            'cantidad',  // También acepta: cantidad_unidades, unidades
            'campana',
            'seccion',
            'familia_ar',  // También acepta: familia_articulo_description
            'cadena',
            'mercado',  // También acepta: mercado_origen_articulo
            'precio_pv',  // También acepta: precio_pvp_maximo_temporada
            'partida_ar',  // También acepta: partida_arancelaria
            'compositi',  // También acepta: composition
            'peso_unit',  // También acepta: peso_unitario
            'grupo_ara',  // También acepta: grupo_arancelario
            'season_in',  // También acepta: season_int
            'categoria',  // También acepta: categoria_seleccionada
            'famillie_u',  // También acepta: famillie_usuario
            'detail_usu',  // También acepta: detail_usuario
            'notes',
        ];
    }

    public function title(): string
    {
        return 'Plantilla Artículos Teóricos';
    }
}


