<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('articles', function (Blueprint $table) {
            $table->id();
            $table->string('mocaco', 20)->index();
            $table->string('seccion', 50)->nullable();
            $table->string('familia', 100)->nullable();
            $table->string('cadena', 50)->nullable();
            $table->string('mercado_origen_articulo', 100)->nullable();
            $table->decimal('precio_pvp_maximo_temporada', 10, 2)->nullable();
            $table->string('partida_arancelaria', 50)->nullable();
            $table->text('composition')->nullable();
            $table->string('campana', 50)->nullable();
            $table->decimal('peso_unitario', 8, 3)->nullable();
            $table->string('grupo_arancelario', 50)->nullable();
            $table->timestamps();
            
            // Índice único compuesto: la combinación mocaco + campana debe ser única
            $table->unique(['mocaco', 'campana'], 'articles_mocaco_campana_unique');
            $table->index(['mocaco', 'familia']);
            $table->index('cadena');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('articles');
    }
};