<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->id();
            $table->foreignId('client_id')->constrained()->onDelete('cascade');
            $table->foreignId('user_id')->constrained()->onDelete('cascade'); // User who created the order
            $table->string('operario_id', 20)->nullable(); // Operator ID from old system
            $table->text('notes')->nullable();
            $table->enum('status', ['draft', 'confirmed', 'dispatched', 'cancelled'])->default('draft');
            $table->timestamp('order_date')->useCurrent();
            $table->timestamp('dispatched_date')->nullable();
            $table->timestamps();
            
            $table->index(['status', 'order_date']);
            $table->index(['client_id', 'status']);
            $table->index('operario_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('orders');
    }
};