<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('relabeling_products', function (Blueprint $table) {
            $table->id();
            $table->string('proveedor_code', 50)->unique()->index();
            $table->string('codebar_gnu', 50)->nullable();
            $table->text('description')->nullable();
            $table->decimal('price_cfa', 10, 2)->nullable();
            $table->timestamps();
            
            $table->index('codebar_gnu');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('relabeling_products');
    }
};