<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // First, update any existing 'confirmed' values to 'pending' to match the controller logic
        DB::table('orders')->where('status', 'confirmed')->update(['status' => 'pending']);
        
        // Modify the enum to include 'pending' and remove 'confirmed'
        DB::statement("ALTER TABLE orders MODIFY COLUMN status ENUM('draft', 'pending', 'dispatched', 'cancelled') DEFAULT 'draft'");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // First, update any existing 'pending' values to 'confirmed' to match the original enum
        DB::table('orders')->where('status', 'pending')->update(['status' => 'confirmed']);
        
        // Revert the enum to the original values
        DB::statement("ALTER TABLE orders MODIFY COLUMN status ENUM('draft', 'confirmed', 'dispatched', 'cancelled') DEFAULT 'draft'");
    }
};