<?php

use App\Enums\ContainerEntryStatus;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (Schema::hasTable('container_entries')) {
            return;
        }
        
        Schema::create('container_entries', function (Blueprint $table) {
            $table->id();
            $table->string('n_camion', 50)->index()->comment('Número de camión/contenedor');
            $table->string('marca', 100)->nullable()->comment('Marca del producto');
            $table->string('tipo_producto', 100)->nullable()->comment('Tipo de producto');
            $table->string('estado', 20)->default(ContainerEntryStatus::EN_PROCESO->value)->index()->comment('Estado del contenedor: En Proceso, Finalizado');
            $table->foreignId('usuario_asignado_id')->nullable()->constrained('users')->onDelete('set null');
            $table->timestamp('fecha_inicio_proceso')->nullable()->comment('Fecha de inicio del proceso');
            $table->timestamp('fecha_finalizacion')->nullable()->comment('Fecha de finalización del proceso');
            $table->text('notes')->nullable()->comment('Notas adicionales');
            $table->timestamps();
            
            // Índices para rendimiento
            $table->index(['estado', 'n_camion']);
            $table->index('fecha_inicio_proceso');
            $table->index('fecha_finalizacion');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('container_entries');
    }
};
