<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('container_entry_user')) {
            return;
        }
        
        Schema::create('container_entry_user', function (Blueprint $table) {
            $table->id();
            $table->foreignId('container_entry_id')->constrained('container_entries')->onDelete('cascade');
            $table->foreignId('user_id')->constrained('users')->onDelete('cascade');
            $table->string('role')->nullable(); // opcional: rol dentro del contenedor
            $table->timestamp('assigned_at')->nullable();
            $table->timestamps();

            $table->unique(['container_entry_id', 'user_id']);
            $table->index(['user_id', 'container_entry_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('container_entry_user');
    }
};


