<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasColumn('orders', 'url_pdf_factura')) {
            return;
        }
        
        Schema::table('orders', function (Blueprint $table) {
            $table->string('url_pdf_factura', 500)->nullable()->after('dispatched_date');
        });
    }

    public function down(): void
    {
        Schema::table('orders', function (Blueprint $table) {
            $table->dropColumn('url_pdf_factura');
        });
    }
};

