<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('scanner_alerts', function (Blueprint $table) {
            $table->id();
            $table->string('type', 50); // 'composition', 'country', etc.
            $table->text('keywords'); // Palabras clave separadas por comas o JSON
            $table->string('description')->nullable(); // Descripción de la alerta
            $table->boolean('is_active')->default(true);
            $table->foreignId('user_id')->nullable()->constrained()->onDelete('cascade'); // Si es null, es global
            $table->timestamps();
            
            $table->index(['type', 'is_active']);
            $table->index('user_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('scanner_alerts');
    }
};
