<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('inventory', function (Blueprint $table) {
            $table->boolean('needs_review')->default(false)->after('status');
            $table->text('review_notes')->nullable()->after('needs_review');
            $table->timestamp('reviewed_at')->nullable()->after('review_notes');
            $table->unsignedBigInteger('reviewed_by')->nullable()->after('reviewed_at');

            $table->foreign('reviewed_by')->references('id')->on('users')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('inventory', function (Blueprint $table) {
            $table->dropForeign(['reviewed_by']);
            $table->dropColumn(['needs_review', 'review_notes', 'reviewed_at', 'reviewed_by']);
        });
    }
};
