<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Add indexes to theoretical_articles table
        Schema::table('theoretical_articles', function (Blueprint $table) {
            try {
                // Composite index for faster duplicate checking
                DB::statement('CREATE INDEX idx_theoretical_container_mocaco_campana
                    ON theoretical_articles(container_entry_id, mocaco, campana(100))');
            } catch (\Exception $e) {
                // Index might already exist, ignore
            }

            try {
                // Index for mocaco lookups
                DB::statement('CREATE INDEX idx_theoretical_mocaco
                    ON theoretical_articles(mocaco)');
            } catch (\Exception $e) {
                // Index might already exist, ignore
            }
        });

        // Add indexes to articles table
        Schema::table('articles', function (Blueprint $table) {
            try {
                // Composite index for faster duplicate checking
                DB::statement('CREATE INDEX idx_articles_mocaco_campana
                    ON articles(mocaco, campana(100))');
            } catch (\Exception $e) {
                // Index might already exist, ignore
            }

            try {
                // Index for mocaco lookups
                DB::statement('CREATE INDEX idx_articles_mocaco
                    ON articles(mocaco)');
            } catch (\Exception $e) {
                // Index might already exist, ignore
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('theoretical_articles', function (Blueprint $table) {
            try {
                DB::statement('DROP INDEX idx_theoretical_container_mocaco_campana ON theoretical_articles');
            } catch (\Exception $e) {
                // Index might not exist, ignore
            }

            try {
                DB::statement('DROP INDEX idx_theoretical_mocaco ON theoretical_articles');
            } catch (\Exception $e) {
                // Index might not exist, ignore
            }
        });

        Schema::table('articles', function (Blueprint $table) {
            try {
                DB::statement('DROP INDEX idx_articles_mocaco_campana ON articles');
            } catch (\Exception $e) {
                // Index might not exist, ignore
            }

            try {
                DB::statement('DROP INDEX idx_articles_mocaco ON articles');
            } catch (\Exception $e) {
                // Index might not exist, ignore
            }
        });
    }
};
