<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Modify the ENUM column to include 'Propuesta de pedido'
        // MySQL specific raw query for modifying enum
        DB::statement("ALTER TABLE inventory MODIFY COLUMN status ENUM('disponible', 'reservado', 'dispatched', 'entregado', 'order_proposal') NOT NULL DEFAULT 'disponible'");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Revert back to original ENUM values
        // Note: This might fail if there are records with 'Propuesta de pedido'
        DB::statement("ALTER TABLE inventory MODIFY COLUMN status ENUM('disponible', 'reservado', 'dispatched', 'entregado') NOT NULL DEFAULT 'disponible'");
    }
};
