<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    use WithoutModelEvents;

    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // Run permission seeder first
        $this->call([
            PermissionSeeder::class,
            ScannerOptionPermissionSeeder::class, // Added
            UserSeeder::class,
            ClientSeeder::class,
            ArticleSeeder::class,
            ContainerEntrySeeder::class,
            TheoreticalArticleSeeder::class,
            InventorySeeder::class,
            ConfigSeeder::class,
            InitialDataSeeder::class,
            ScannerOptionSeeder::class, // Added
        ]);
    }
}
