<?php

namespace Database\Seeders;

use App\Models\Inventory;
use App\Models\Article;
use Illuminate\Database\Seeder;

class InventorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Los artículos se crearán desde el ArticleSeeder, solo creamos los items de inventario aquí

        // Crear items de inventario para el contenedor PT233I23
        $inventoryItems = [
            [
                'full_barcode' => '07554332805985',
                'mocaco' => 'ART001',
                'n_carton' => 'CAJA001',
                'season_int' => 'ÉTÉ',
                'ubicacion' => '01-01-01',
                'n_id_operario' => 'OP001',
                'categoria_seleccionada' => 'CAT. 1',
                'famillie_usuario' => 'MAILLE',
                'detail_usuario' => 'PULL LEGER',
                'seccion' => 'Sección A',
                'familia_articulo_description' => 'MAILLE',
                'cadena' => 'CAM01',
                'mercado_origen_articulo' => 'España',
                'precio_pvp_maximo_temporada' => 29.99,
                'partida_arancelaria' => '6109.10',
                'composition' => '100% algodón',
                'campana' => '2024',
                'peso_unitario' => 0.250,
                'grupo_arancelario' => 'TEXTIL',
                'notes' => 'Item en perfecto estado',
                'conteneur' => 'PT233I23',
            ],
            [
                'full_barcode' => '07554315712026',
                'mocaco' => 'ART002',
                'n_carton' => 'CAJA001',
                'season_int' => 'ÉTÉ',
                'ubicacion' => '01-01-02',
                'n_id_operario' => 'OP001',
                'categoria_seleccionada' => 'CAT. 1',
                'famillie_usuario' => 'MAILLE',
                'detail_usuario' => 'PULL LEGER',
                'seccion' => 'Sección A',
                'familia_articulo_description' => 'MAILLE',
                'cadena' => 'PAN01',
                'mercado_origen_articulo' => 'Turquía',
                'precio_pvp_maximo_temporada' => 45.50,
                'partida_arancelaria' => '6203.42',
                'composition' => '70% algodón, 30% poliéster',
                'campana' => '2024',
                'peso_unitario' => 0.450,
                'grupo_arancelario' => 'TEXTIL',
                'notes' => 'Talla disponible',
                'conteneur' => 'PT233I23',
            ],
            [
                'full_barcode' => '07554313712035',
                'mocaco' => 'ART003',
                'n_carton' => 'CAJA001',
                'season_int' => 'ÉTÉ',
                'ubicacion' => '01-01-03',
                'n_id_operario' => 'OP001',
                'categoria_seleccionada' => 'CAT. 1',
                'famillie_usuario' => 'MAILLE',
                'detail_usuario' => 'PULL LOURD',
                'seccion' => 'Sección B',
                'familia_articulo_description' => 'MAILLE',
                'cadena' => 'CAL01',
                'mercado_origen_articulo' => 'China',
                'precio_pvp_maximo_temporada' => 79.99,
                'partida_arancelaria' => '6404.20',
                'composition' => 'Cuero sintético',
                'campana' => '2024',
                'peso_unitario' => 0.800,
                'grupo_arancelario' => 'CALZADO',
                'notes' => 'Múltiples tallas',
                'conteneur' => 'PT233I23',
            ],
            [
                'full_barcode' => '0035553138040',
                'mocaco' => 'ART004',
                'n_carton' => 'CAJA002',
                'season_int' => 'HIVER',
                'ubicacion' => '02-01-01',
                'n_id_operario' => 'OP002',
                'categoria_seleccionada' => 'CAT. 0',
                'famillie_usuario' => 'EXTERIEUR',
                'detail_usuario' => 'MANTEAU BOMB',
                'seccion' => 'Sección C',
                'familia_articulo_description' => 'Bolsos',
                'cadena' => 'BOL01',
                'mercado_origen_articulo' => 'Italia',
                'precio_pvp_maximo_temporada' => 89.99,
                'partida_arancelaria' => '4202.12',
                'composition' => 'Cuero genuino',
                'campana' => '2024',
                'peso_unitario' => 0.600,
                'grupo_arancelario' => 'ACCESORIOS',
                'notes' => 'Edición limitada',
                'conteneur' => 'PT233I23',
            ],
            [
                'full_barcode' => '00554324567890',
                'mocaco' => 'ART005',
                'n_carton' => 'CAJA003',
                'season_int' => 'PRINTEMPS',
                'ubicacion' => '03-01-01',
                'n_id_operario' => 'OP003',
                'categoria_seleccionada' => 'CAT. 2',
                'famillie_usuario' => 'T-SHIRT',
                'detail_usuario' => 'COURTE',
                'seccion' => 'Sección D',
                'familia_articulo_description' => 'Chaquetas',
                'cadena' => 'CHA01',
                'mercado_origen_articulo' => 'Portugal',
                'precio_pvp_maximo_temporada' => 129.99,
                'partida_arancelaria' => '6201.93',
                'composition' => 'Poliéster impermeable',
                'campana' => '2024',
                'peso_unitario' => 0.950,
                'grupo_arancelario' => 'TEXTIL',
                'notes' => 'Impermeable',
                'conteneur' => 'PT233I23',
            ],
        ];

        foreach ($inventoryItems as $itemData) {
            Inventory::firstOrCreate(
                ['full_barcode' => $itemData['full_barcode']],
                $itemData
            );
        }

        $this->command->info('Inventory items created successfully!');
        $this->command->info('Created ' . count($inventoryItems) . ' inventory items');
    }
}