<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class PermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Reset cached roles and permissions
        app()[\Spatie\Permission\PermissionRegistrar::class]->forgetCachedPermissions();

        // Create permissions for Inventory Management
        $permissions = [
            // Inventory permissions
            'inventory.view',
            'inventory.create',
            'inventory.edit',
            'inventory.delete',
            'inventory.scan',
            'inventory.assign_location',
            
            // Article permissions
            'articles.view',
            'articles.create',
            'articles.edit',
            'articles.delete',
            
            // Client permissions
            'clients.view',
            'clients.create',
            'clients.edit',
            'clients.delete',
            
            // Order permissions
            'orders.view',
            'orders.create',
            'orders.edit',
            'orders.delete',
            'orders.prepare',
            'orders.dispatch',
            
            // Relabeling permissions
            'relabeling.view',
            'relabeling.create',
            'relabeling.edit',
            'relabeling.delete',
            'relabeling.print',
            
            // User management permissions
            'users.view',
            'users.create',
            'users.edit',
            'users.delete',
            
            // Reports permissions
            'reports.view',
            'reports.export',
            
            // System permissions
            'system.settings',
            'system.backup',
            'system.logs',
        ];

        foreach ($permissions as $permission) {
            Permission::firstOrCreate(['name' => $permission]);
        }

        // Create roles
        $adminRole = Role::firstOrCreate(['name' => 'admin']);
        $operatorRole = Role::firstOrCreate(['name' => 'operator']);
        $viewerRole = Role::firstOrCreate(['name' => 'viewer']);

        // Assign all permissions to admin
        $adminRole->givePermissionTo(Permission::all());

        // Assign specific permissions to operator
        $operatorPermissions = [
            'inventory.view',
            'inventory.create',
            'inventory.edit',
            'inventory.scan',
            'inventory.assign_location',
            'articles.view',
            'articles.create',
            'articles.edit',
            'clients.view',
            'clients.create',
            'clients.edit',
            'orders.view',
            'orders.create',
            'orders.edit',
            'orders.prepare',
            'orders.dispatch',
            'relabeling.view',
            'relabeling.create',
            'relabeling.edit',
            'relabeling.print',
            'reports.view',
            'reports.export',
        ];
        
        $operatorRole->givePermissionTo($operatorPermissions);

        // Assign limited permissions to viewer
        $viewerPermissions = [
            'inventory.view',
            'articles.view',
            'clients.view',
            'orders.view',
            'relabeling.view',
            'reports.view',
        ];
        
        $viewerRole->givePermissionTo($viewerPermissions);

        $this->command->info('Permissions and roles created successfully!');
        $this->command->info('Admin role: All permissions');
        $this->command->info('Operator role: Inventory, Articles, Clients, Orders, Relabeling, Reports');
        $this->command->info('Viewer role: View only permissions');
    }
}