<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class ScannerOptionPermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Define permissions
        $permissions = [
            'scanner-options.view',
            'scanner-options.create',
            'scanner-options.update',
            'scanner-options.delete',
        ];

        // Create permissions
        foreach ($permissions as $permission) {
            Permission::firstOrCreate(['name' => $permission]);
        }

        // Assign permissions to admin role
        $role = Role::where('name', 'admin')->first();
        if ($role) {
            $role->givePermissionTo($permissions);
        }
    }
}
