<?php

namespace Database\Seeders;

use App\Models\ContainerEntry;
use App\Models\TheoreticalArticle;
use Illuminate\Database\Seeder;

class TheoreticalArticleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Obtener el contenedor PT233I23 (el que ya tiene inventory items)
        $containerPT233I23 = ContainerEntry::where('n_camion', 'PT233I23')->first();
        
        if (!$containerPT233I23) {
            $this->command->warn('Container PT233I23 not found. Please run ContainerEntrySeeder first.');
            return;
        }

        // Artículos teóricos basados en los artículos existentes del ArticleSeeder
        // Estos representan el inventario esperado del contenedor
        $theoreticalArticles = [
            [
                'container_entry_id' => $containerPT233I23->id,
                'mocaco' => 'ART001',
                'cantidad_unidades' => 50, // 50 unidades esperadas de este artículo
                'season_int' => 'ÉTÉ',
                'categoria_seleccionada' => 'CAT. 1',
                'famillie_usuario' => 'MAILLE',
                'detail_usuario' => 'PULL LEGER',
                'seccion' => 'Sección A',
                'familia_articulo_description' => 'Camisetas',
                'cadena' => 'CAM01',
                'mercado_origen_articulo' => 'España',
                'precio_pvp_maximo_temporada' => 29.99,
                'partida_arancelaria' => '6109.10',
                'composition' => '100% algodón',
                'campana' => '2024',
                'peso_unitario' => 0.250,
                'grupo_arancelario' => 'TEXTIL',
                'notes' => 'Artículo teórico - Camisetas temporada verano',
            ],
            [
                'container_entry_id' => $containerPT233I23->id,
                'mocaco' => 'ART002',
                'cantidad_unidades' => 30,
                'season_int' => 'ÉTÉ',
                'categoria_seleccionada' => 'CAT. 1',
                'famillie_usuario' => 'MAILLE',
                'detail_usuario' => 'PULL LEGER',
                'seccion' => 'Sección A',
                'familia_articulo_description' => 'Pantalones',
                'cadena' => 'PAN01',
                'mercado_origen_articulo' => 'Turquía',
                'precio_pvp_maximo_temporada' => 45.50,
                'partida_arancelaria' => '6203.42',
                'composition' => '70% algodón, 30% poliéster',
                'campana' => '2024',
                'peso_unitario' => 0.450,
                'grupo_arancelario' => 'TEXTIL',
                'notes' => 'Artículo teórico - Pantalones',
            ],
            [
                'container_entry_id' => $containerPT233I23->id,
                'mocaco' => 'ART003',
                'cantidad_unidades' => 20,
                'season_int' => 'ÉTÉ',
                'categoria_seleccionada' => 'CAT. 1',
                'famillie_usuario' => 'MAILLE',
                'detail_usuario' => 'PULL LOURD',
                'seccion' => 'Sección B',
                'familia_articulo_description' => 'Calzado Deportivo',
                'cadena' => 'CAL01',
                'mercado_origen_articulo' => 'China',
                'precio_pvp_maximo_temporada' => 79.99,
                'partida_arancelaria' => '6404.20',
                'composition' => 'Cuero sintético',
                'campana' => '2024',
                'peso_unitario' => 0.800,
                'grupo_arancelario' => 'CALZADO',
                'notes' => 'Artículo teórico - Calzado deportivo',
            ],
            [
                'container_entry_id' => $containerPT233I23->id,
                'mocaco' => 'ART004',
                'cantidad_unidades' => 15,
                'season_int' => 'HIVER',
                'categoria_seleccionada' => 'CAT. 0',
                'famillie_usuario' => 'EXTERIEUR',
                'detail_usuario' => 'MANTEAU BOMB',
                'seccion' => 'Sección C',
                'familia_articulo_description' => 'Bolsos',
                'cadena' => 'BOL01',
                'mercado_origen_articulo' => 'Italia',
                'precio_pvp_maximo_temporada' => 89.99,
                'partida_arancelaria' => '4202.12',
                'composition' => 'Cuero genuino',
                'campana' => '2024',
                'peso_unitario' => 0.600,
                'grupo_arancelario' => 'ACCESORIOS',
                'notes' => 'Artículo teórico - Bolsos edición limitada',
            ],
            [
                'container_entry_id' => $containerPT233I23->id,
                'mocaco' => 'ART005',
                'cantidad_unidades' => 25,
                'season_int' => 'PRINTEMPS',
                'categoria_seleccionada' => 'CAT. 2',
                'famillie_usuario' => 'T-SHIRT',
                'detail_usuario' => 'COURTE',
                'seccion' => 'Sección D',
                'familia_articulo_description' => 'Chaquetas',
                'cadena' => 'CHA01',
                'mercado_origen_articulo' => 'Portugal',
                'precio_pvp_maximo_temporada' => 129.99,
                'partida_arancelaria' => '6201.93',
                'composition' => 'Poliéster impermeable',
                'campana' => '2024',
                'peso_unitario' => 0.950,
                'grupo_arancelario' => 'TEXTIL',
                'notes' => 'Artículo teórico - Chaquetas impermeables',
            ],
        ];

        // Crear artículos teóricos para PT233I23
        foreach ($theoreticalArticles as $articleData) {
            TheoreticalArticle::firstOrCreate(
                [
                    'container_entry_id' => $articleData['container_entry_id'],
                    'mocaco' => $articleData['mocaco'],
                ],
                $articleData
            );
        }

        // Crear artículos teóricos para el segundo contenedor (PT233I24)
        $containerPT233I24 = ContainerEntry::where('n_camion', 'PT233I24')->first();
        if ($containerPT233I24) {
            $theoreticalArticles2 = [
                [
                    'container_entry_id' => $containerPT233I24->id,
                    'mocaco' => 'ART001',
                    'cantidad_unidades' => 40,
                    'season_int' => 'ÉTÉ',
                    'categoria_seleccionada' => 'CAT. 1',
                    'famillie_usuario' => 'MAILLE',
                    'detail_usuario' => 'PULL LEGER',
                    'seccion' => 'Sección A',
                    'familia_articulo_description' => 'Camisetas',
                    'cadena' => 'CAM01',
                    'mercado_origen_articulo' => 'España',
                    'precio_pvp_maximo_temporada' => 29.99,
                    'partida_arancelaria' => '6109.10',
                    'composition' => '100% algodón',
                    'campana' => '2024',
                    'peso_unitario' => 0.250,
                    'grupo_arancelario' => 'TEXTIL',
                    'notes' => 'Segunda carga - Artículo teórico',
                ],
                [
                    'container_entry_id' => $containerPT233I24->id,
                    'mocaco' => 'ART002',
                    'cantidad_unidades' => 35,
                    'season_int' => 'ÉTÉ',
                    'categoria_seleccionada' => 'CAT. 1',
                    'famillie_usuario' => 'MAILLE',
                    'detail_usuario' => 'PULL LEGER',
                    'seccion' => 'Sección A',
                    'familia_articulo_description' => 'Pantalones',
                    'cadena' => 'PAN01',
                    'mercado_origen_articulo' => 'Turquía',
                    'precio_pvp_maximo_temporada' => 45.50,
                    'partida_arancelaria' => '6203.42',
                    'composition' => '70% algodón, 30% poliéster',
                    'campana' => '2024',
                    'peso_unitario' => 0.450,
                    'grupo_arancelario' => 'TEXTIL',
                    'notes' => 'Segunda carga - Artículo teórico',
                ],
            ];

            foreach ($theoreticalArticles2 as $articleData) {
                TheoreticalArticle::firstOrCreate(
                    [
                        'container_entry_id' => $articleData['container_entry_id'],
                        'mocaco' => $articleData['mocaco'],
                    ],
                    $articleData
                );
            }
        }

        $total = TheoreticalArticle::count();
        $this->command->info('Theoretical articles created successfully!');
        $this->command->info("Total theoretical articles in database: {$total}");
    }
}

