# Documentación Completa del Sistema de Inventario

Este documento contiene tanto el Manual Técnico (Arquitectura) como el Manual de Usuario (Operativa Diaria).

---

# PARTE 1: Manual Técnico de Arquitectura

## 1. Visión General del Sistema
Este sistema es una plataforma web integral para la gestión de inventario, logística y operaciones de almacén. Está construido sobre una arquitectura robusta que combina patrones MVC (Modelo-Vista-Controlador) con principios de Diseño Guiado por el Dominio (DDD) para módulos complejos.

El sistema gestiona el flujo completo de mercancías: desde la entrada de contenedores y recepción, pasando por el almacenamiento y etiquetado, hasta la preparación de pedidos y despacho a clientes.

## 2. Pila Tecnológica (Tech Stack)

### Backend
- **Framework**: Laravel 12.x (PHP 8.2+)
- **Base de Datos**: MySQL
- **Autenticación**: Laravel Sanctum / Session-based
- **Permisos**: Spatie Laravel Permission
- **Generación de Documentos**: DomPDF (PDFs), Maatwebsite Excel (Reportes)

### Frontend
- **Framework**: Vue.js (vía Inertia.js)
- **Estilos**: Tailwind CSS (inferido)
- **Comunicación**: Axios (vía Inertia)
- **Impresión**: QZ Tray (Integración WebSocket para impresión térmica directa)

### Infraestructura
- **Servidor Web**: Nginx
- **Contenedores**: Docker (opcional para desarrollo)

## 3. Arquitectura de Módulos

El sistema está organizado en módulos funcionales que se reflejan tanto en la estructura de base de datos como en la lógica de negocio.

### 3.1. Módulo de Inventario (Core)
Responsable de mantener el estado actual de cada artículo y caja en el almacén.
- **Modelos Principales**:
    - `Inventory`: Representa una unidad física (caja/ítem) con ubicación y cantidad.
    - `Article`: Catálogo maestro de productos (MOCACO, descripción, dimensiones).
    - `Brand`: Marcas asociadas a los artículos.
    - `Location`: (Gestionado vía lógica) Ubicaciones físicas en el almacén.

### 3.2. Módulo de Entradas (Inbound)
Gestiona la recepción de mercancía desde contenedores.
- **Modelos Principales**:
    - `ContainerEntry`: Cabecera de la entrada (Nº Contenedor, Fecha).
    - `TheoreticalArticle`: Lista de empaque esperada (Manifiesto/Packing List).
    - `ImportProgress`: Rastreo del proceso de importación masiva de datos.
- **Flujo**: Carga de Excel (Teórico) -> Escaneo Físico (Comparación) -> Reporte de Discrepancias -> Finalización y Alta en Inventario.

### 3.3. Módulo de Salidas y Pedidos (Outbound)
Gestiona las solicitudes de clientes y la preparación de pedidos.
- **Modelos Principales**:
    - `Order`: Cabecera del pedido (Cliente, Estado, Fechas).
    - `OrderItem`: Líneas del pedido.
    - `BoxReservation`: Lógica compleja para "apartar" cajas específicas del inventario para un pedido.
    - `BoxReservationItem`: Relación N:M entre pedidos y cajas de inventario.
- **Flujo**: Pedido (Web/Portal) -> Reserva de Stock (Automática/Manual) -> Picking -> Despacho.

### 3.4. Módulo de Clientes (CRM & Portal)
Gestión de cartera de clientes y su acceso al portal de autoservicio.
- **Modelos Principales**:
    - `Client`: Datos fiscales y comerciales.
    - `User`: Usuarios del sistema (Admin, Operarios) y Clientes (con rol `client`).

### 3.5. Sistema de Escaneo y Etiquetado
Módulo operativo para trabajadores de planta.
- **Modelos Principales**:
    - `ScannerAlert`: Alertas configurables al escanear ciertos productos (ej. "Frágil", "Revisar Calidad").
    - `RelabelingProduct`: Gestión de re-etiquetado.
- **Integraciones**: Conexión directa con impresoras Zebra/ZPL mediante QZ Tray.

## 4. Seguridad y Control de Acceso

La seguridad se maneja a través de Roles y Permisos (`spatie/laravel-permission`):

- **Roles**:
    - `admin`: Acceso total.
    - `operario`: Acceso limitado a Scanner, Entradas y Tareas de Almacén.
    - `client`: Acceso exclusivo al Portal de Clientes.
- **Middleware**: Rutas protegidas por `auth`, `role:admin`, `permission:inventory.view`, etc.

## 5. Integraciones y Servicios Externos

- **Excel (Maatwebsite/Rap2hpoutre)**: Motor intensivo de importación/exportación para cargas masivas de datos teóricos y reportes de inventario.
- **QZ Tray**: Servicio de escritorio requerido en las estaciones de trabajo para permitir que el navegador web envíe comandos ZPL crudos (Raw Print) a las impresoras térmicas sin diálogos de impresión del sistema operativo.

## 6. Estructura de Directorios Clave

- `app/Models`: Definiciones de Eloquent ORM.
- `app/Http/Controllers`: Lógica de presentación y orquestación de peticiones.
- `src/Domain`: Lógica de negocio encapsulada (DDD) - *En transición/implementación*.
- `routes/web.php`: Definición central de endpoints y middleware.
- `resources/js`: Componentes Vue y lógica frontend.

## 7. Diagrama de Flujo de Datos (Simplificado)

1. **Entrada**: Archivo Excel -> `TheoreticalArticle`
2. **Recepción**: Scanner App -> `Inventory` (Estado: Recibido)
3. **Almacenamiento**: Asignación de Ubicación -> `Inventory` (Update Ubicación)
4. **Pedido**: `Article` -> `Order` -> `BoxReservation` (Bloqueo de `Inventory`)
5. **Salida**: Confirmación Despacho -> `Inventory` (Eliminación lógica/Histórico).

\newpage

---

# PARTE 2: Manual de Usuario - Operativa Diaria

## 1. Introducción y Acceso

Bienvenido al Sistema de Gestión de Inventario. Este manual describe los procedimientos estándar para la operación diaria del almacén y la gestión administrativa.

### Roles de Usuario
- **Administrador**: Control total (Configuración, Usuarios, Gestión Financiera).
- **Operario**: Tareas de almacén (Entradas, Escaneo, Etiquetado).
- **Cliente**: Acceso limitado para ver sus pedidos y descargar facturas.

### Acceso al Sistema
1. Navegue a la URL del sistema.
2. Ingrese sus credenciales (Email y Contraseña).
3. Si es su primera vez, solicite al administrador que le asigne un rol.

---

## 2. Gestión de Entradas (Recepción de Mercancía)

La gestión de contenedores es el primer paso para ingresar stock.

### Paso 1: Crear Entrada de Contenedor
1. Vaya a **"Entradas Contenedores"** en el menú.
2. Haga clic en **"Nueva Entrada"**.
3. Ingrese el **Número de Camión/Contenedor** (Obligatorio).
4. (Opcional) Asigne un usuario responsable.

### Paso 2: Cargar Artículos Teóricos (Packing List)
Antes de escanear, el sistema necesita saber qué se espera recibir.
1. En el detalle del contenedor, busque "Artículos Teóricos".
2. **Descargue la Plantilla Excel** si no la tiene.
3. Llene el Excel. Columnas críticas: `mocaco` (código de producto) y `cantidad_unidades`.
4. Suba el archivo en la sección de carga.
5. El sistema procesará el archivo (puede tardar unos minutos si es grande).

### Paso 3: Escaneo Físico y Asignación
1. Los operarios usan la sección **Escáner**.
2. Al escanear una caja, se valida contra el "Teórico".
3. Se puede asignar **múltiples usuarios** a un contenedor haciendo clic en el icono 👥 en la lista de contenedores.

### Paso 4: Finalizar Contenedor
1. Cuando se haya descargado todo, el supervisor revisa el **Progreso**.
2. Haga clic en **"Finalizar"**.
3. El sistema mostrará un **Reporte de Discrepancias** (Faltantes vs. Sobrantes).
4. Si está conforme, confirme la finalización. Esto sumará el stock al Inventario General.

---

## 3. Gestión de Inventario y Etiquetas

### Consultar Inventario
- Vaya a **"Inventario"**.
- Use los filtros para buscar por MOCACO, Marca o Descripción.
- **Exportar**: Puede descargar el stock actual en Excel (agrupado por modelo o detallado).

### Impresión de Etiquetas (Scanner)
Para reimprimir etiquetas dañadas o nuevas:
1. Asegúrese de tener **QZ Tray** ejecutándose en su PC. (Icono verde en la barra de tareas).
2. Vaya a **Escáner**.
3. Use el botón **"Imprimir Etiqueta"** tras escanear una caja.
4. Para reimprimir una caja antigua: Use el botón **"Reimprimir"** e ingrese el número de caja.

---

## 4. Gestión de Pedidos y Salidas

### Procesar un Pedido
1. Los pedidos llegan vía web o se crean manualmente en **"Pedidos"**.
2. **Reserva de Stock**: El sistema intenta reservar cajas automáticamente. Si falta stock, el pedido queda parcialmente reservado.
3. **Picking**: El personal de almacén recoge las cajas indicadas en la "Hoja de Preparación".
4. **Despacho**: Una vez preparado, se marca como "Despachado". Esto descuenta definitivamente el stock.

---

## 5. Portal de Clientes (Guía para sus Clientes)

Sus clientes tienen un acceso privado para autogestión.

### Funcionalidades del Portal
1. **Ver Mis Reservas**: Lista de todos sus pedidos (Reservados, Confirmados, Despachados).
2. **Detalle**: Al hacer clic en "Ver", pueden consultar el *Packing List* detallado de su pedido.
3. **Facturas**: Si el administrador cargó la factura, aparecerá un botón **"Descargar Factura PDF"**.

---

## 6. Solución de Problemas Comunes

### No puedo imprimir etiquetas
- **Causa**: QZ Tray no está corriendo o no tiene certificado.
- **Solución**: Abra QZ Tray en su escritorio. Recargue la página web. Verifique que la impresora Zebra esté conectada y sea la predeterminada o seleccionada en configuración.

### El Excel de carga da error
- **Causa**: Formato de fecha incorrecto o columnas faltantes.
- **Solución**: Use siempre la plantilla descargable más reciente. No cambie los nombres de las cabeceras. Asegúrese de que el `mocaco` no esté vacío.

### No veo el botón de "Finalizar"
- **Causa**: Permisos insuficientes.
- **Solución**: Solo los usuarios con rol `admin` o permisos especiales de supervisor pueden finalizar contenedores con discrepancias.
