<?php

return [
    'common' => [
        'back' => 'Back',
        'cancel' => 'Cancel',
        'assign' => 'Assign',
        'filter' => 'Filter',
        'clear' => 'Clear',
        'view' => 'View',
        'edit' => 'Edit',
        'assign_users' => 'Assign Users',
        'not_assigned' => 'Unassigned',
        'in_process' => 'In progress',
        'not_available' => 'N/A',
    ],

    'index' => [
        'title' => 'Container Entries',
        'buttons' => [
            'theoretical_template' => 'Theoretical Template (XLSX)',
            'export_unprocessed' => 'Export Unprocessed (XLSX)',
            'new_entry' => 'New Entry',
        ],
        'modal' => [
            'title' => 'Assign Users',
            'description' => 'Select one or more users to assign them to this container.',
            'submit' => 'Assign',
        ],
        'filters' => [
            'status' => 'Status',
            'all' => 'All',
            'truck_number' => 'Truck Number',
            'search_placeholder' => 'Search...',
            'assigned_user' => 'Assigned User',
            'filter' => 'Filter',
            'clear' => 'Clear',
        ],
        'pagination' => [
            'per_page' => 'Rows per page:',
            'page_info' => 'Page :current of :last (:total records)',
            'prev' => '« Previous',
            'next' => 'Next »',
        ],
        'table' => [
            'title' => 'Container Entries List',
            'headers' => [
                'id' => 'ID',
                'truck_number' => 'Truck #',
                'brand' => 'Brand',
                'product_type' => 'Product Type',
                'status' => 'Status',
                'assigned_users' => 'Assigned Users',
                'progress' => 'Progress',
                'cycle_time' => 'Cycle Time',
                'created_at' => 'Created At',
                'actions' => 'Actions',
            ],
            'progress_units' => ':scanned / :theoretical units',
            'primary_label' => ' (primary)',
            'empty' => 'No container entries found.',
        ],
    ],

    'form' => [
        'truck_label' => 'Truck/Container #',
        'brand' => 'Brand',
        'product_type' => 'Product Type',
        'assigned_user' => 'Assigned User',
        'assigned_user_placeholder' => 'Unassigned',
        'notes' => 'Notes',
    ],

    'create' => [
        'title' => 'New Container Entry',
        'submit' => 'Create Entry',
    ],

    'edit' => [
        'title' => 'Edit Entry #:id',
        'submit' => 'Update',
    ],

    'show' => [
        'title' => 'Entry #:id - :truck',
        'finalize' => 'Finalize',
        'finalize_confirm' => 'Finalize this container? A discrepancy report will be generated.',
        'force_finalize' => 'Finalize Anyway',
        'force_finalize_confirm' => 'Finalize this container ANYWAY? It will be saved with discrepancies.',
        'info_card' => 'General Information',
        'fields' => [
            'truck_number' => 'Truck #:',
            'status' => 'Status:',
            'brand' => 'Brand:',
            'product_type' => 'Product Type:',
            'assigned_user' => 'Assigned User:',
            'created_at' => 'Created At:',
            'start_date' => 'Process Start Date:',
            'finish_date' => 'Completion Date:',
            'cycle_time' => 'Cycle Time:',
            'notes' => 'Notes:',
        ],
        'assign_user' => [
            'change' => 'Change user...',
            'assign' => 'Assign user...',
        ],
        'progress_card' => 'Scanning Progress',
        'progress_completed' => 'Completed',
        'progress_fields' => [
            'theoretical_units' => 'Theoretical Units:',
            'scanned_units' => 'Scanned Units:',
            'remaining_units' => 'Remaining Units:',
        ],
        'progress_empty' => 'No theoretical items uploaded yet.',
        'theoretical' => [
            'title' => 'Theoretical Items',
            'badge' => ':count items',
            'upload_label' => 'Upload Theoretical Items Excel',
            'upload_help' => 'Format: Excel (.xlsx, .xls) or CSV. Must include MOCACO column and quantity.',
            'upload_button' => 'Upload Excel',
            'table_headers' => [
                'mocaco' => 'MOCACO',
                'units' => 'Units',
                'family' => 'Family',
                'section' => 'Section',
                'campaign' => 'Campaign',
            ],
            'showing' => 'Showing :shown of :total items',
            'empty' => 'No theoretical items uploaded. Upload an Excel file to get started.',
        ],
        'discrepancies' => [
            'title' => 'Discrepancy Report',
            'summary' => [
                'total_theoretical' => 'Total Theoretical:',
                'total_scanned' => 'Total Scanned:',
                'missing' => 'Missing:',
                'excess' => 'Excess:',
            ],
            'table_headers' => [
                'mocaco' => 'MOCACO',
                'theoretical' => 'Theoretical',
                'scanned' => 'Scanned',
                'difference' => 'Difference',
                'type' => 'Type',
            ],
            'types' => [
                'faltante' => 'Missing',
                'exceso' => 'Excess',
                'no_esperado' => 'Unexpected',
            ],
            'showing' => 'Showing :shown of :total discrepancies',
            'download' => 'Download Full Report (Excel)',
            'none' => 'No discrepancies found.',
        ],
        'alerts' => [
            'error_title' => 'Error',
            'discrepancies_found' => 'Discrepancies Found',
            'discrepancy_total' => 'Total discrepancies:',
            'summary' => 'Summary:',
            'total_theoretical' => 'Total Theoretical:',
            'total_scanned' => 'Total Scanned:',
            'force_info' => 'Review the detailed report below or finalize anyway using the "Finalize Anyway" button.',
        ],
    ],
];
