<?php

return [
    'title' => 'Role Management',
    'create' => 'Create Role',
    'edit' => 'Edit Role',
    'view' => 'Role Details',
    'back' => 'Back',
    'new' => 'New Role',
    'create_new' => 'Create New Role',
    
    'table' => [
        'title' => 'Roles',
        'total' => 'roles',
        'id' => 'ID',
        'name' => 'Name',
        'permissions' => 'Permissions',
        'users' => 'Users',
        'actions' => 'Actions',
        'no_roles' => 'No roles found',
        'no_roles_message' => 'Create a new role to get started.',
        'create_first' => 'Create First Role',
        'permissions_count' => 'permissions',
        'no_permissions' => 'No permissions',
        'users_count' => 'users',
    ],
    
    'fields' => [
        'name' => 'Role Name',
        'name_placeholder' => 'E.g: supervisor',
        'name_hint' => 'Use only lowercase letters and underscores.',
        'permissions' => 'Permissions',
    ],
    
    'info' => [
        'title' => 'Information',
        'role_info' => 'Role Information',
        'name_note' => 'Role Name:',
        'name_description' => 'Use only lowercase letters and underscores. No spaces.',
        'permissions_note' => 'Permissions:',
        'permissions_description' => 'Select the permissions this role will have.',
        'example' => 'Example:',
        'example_text' => '\'inventory.view\', \'orders.create\'',
        'name_edit_note' => 'Role Name:',
        'name_edit_description' => 'You can change the role name.',
        'permissions_edit_note' => 'Permissions:',
        'permissions_edit_description' => 'Update the selected permissions.',
        'users_note' => 'Users:',
        'users_description' => ':count users have this role.',
    ],
    
    'show' => [
        'id' => 'ID:',
        'name' => 'Name:',
        'guard' => 'Guard:',
        'created' => 'Created:',
        'permissions_assigned' => 'Assigned Permissions',
        'users_with_role' => 'Users with this Role',
        'no_users' => 'No users have this role.',
        'actions' => 'Actions',
        'edit_role' => 'Edit Role',
        'delete_role' => 'Delete Role',
        'statistics' => 'Statistics',
        'total_permissions' => 'Total Permissions:',
        'assigned_permissions' => 'Assigned Permissions:',
        'assigned_users' => 'Assigned Users:',
        'user_id' => 'ID',
        'user_name' => 'Name',
        'user_email' => 'Email',
        'user_status' => 'Status',
    ],
    
    'buttons' => [
        'create' => 'Create Role',
        'update' => 'Update Role',
        'cancel' => 'Cancel',
        'delete' => 'Delete Role',
        'view_permissions' => 'View Permissions',
        'edit' => 'Edit',
    ],
    
    'messages' => [
        'delete_confirm' => 'Are you sure you want to delete this role?',
    ],
    
    'categories' => [
        'title' => 'Permission Categories',
        'inventory' => 'Inventory:',
        'inventory_perms' => 'inventory.view, inventory.create, inventory.edit, inventory.delete',
        'articles' => 'Articles:',
        'articles_perms' => 'articles.view, articles.create, articles.edit, articles.delete',
        'clients' => 'Clients:',
        'clients_perms' => 'clients.view, clients.create, clients.edit, clients.delete',
        'orders' => 'Orders:',
        'orders_perms' => 'orders.view, orders.create, orders.edit, orders.delete',
        'relabeling' => 'Relabeling:',
        'relabeling_perms' => 'relabeling.view, relabeling.create, relabeling.edit, relabeling.delete',
        'users' => 'Users:',
        'users_perms' => 'users.view, users.create, users.edit, users.delete',
    ],
    
    'status' => [
        'active' => 'Active',
        'inactive' => 'Inactive',
    ],
];

