<?php

return [
    'title' => 'Inventory Scanner',
    'back_to_inventory' => 'Back to Inventory',
    
    'sections' => [
        'user_location' => 'User Data and Location',
        'article_characteristics' => 'Article Characteristics (User Selection)',
        'barcode_scanning' => 'Barcode Scanning',
        'article_info' => 'ARTICLE INFO (from database)',
        'box_content' => 'Current Box Content',
        'alerts' => 'Alerts',
    ],
    
    'fields' => [
        'operator_id' => 'OPERATOR ID NO.',
        'box_number' => 'BOX NO.',
        'box_number_placeholder' => 'Scan the box number here',
        'container' => 'CONTAINER (Truck No.)',
        'container_assigned' => 'Container assigned',
        'notes' => 'NOTES:',
        'season_int' => 'SEASON INT. (Internal Season)',
        'category' => 'SELECTED CATEGORY',
        'family' => 'USER FAMILY',
        'detail' => 'USER DETAIL',
        'location' => 'LOCATION (Aisle-Shelf-Position, e.g. 01-01-02):',
        'location_placeholder' => 'E.g. 01-01-02',
        'barcode_scan' => 'Scan Barcode:',
    ],
    
    'buttons' => [
        'auto_generate' => 'Auto',
        'auto_generate_title' => 'Automatically generate box number',
        'auto_generate_note' => 'Press "Auto" to automatically generate the next number',
        'delete_last' => 'Delete Last Scan',
        'delete_last_title' => 'Delete last article scanned by you',
        'print_label' => 'Print Label',
        'print_label_title' => 'Print Box Label',
        'generate_pdf' => 'Generate PDF',
        'generate_pdf_title' => 'Generate PDF CONTENU DU COLIS',
        'reprint' => 'Reprint',
        'reprint_title' => 'Reprint Label',
        'add_alert' => 'Add Alert',
        'add_alert_title' => 'Add new alert',
        'cancel' => 'Cancel',
        'save' => 'Save',
        'search' => 'Search',
        'print' => 'Print',
        'add_article' => 'Add Article',
    ],
    
    'messages' => [
        'scan_article' => 'Scan an article to see the content.',
        'loading_alerts' => 'Loading alerts...',
        'select_article' => 'Select the Correct Article',
        'multiple_articles' => 'Multiple articles were found with this barcode. Please select the one that corresponds:',
        'reprint_title' => 'Reprint Box Label',
        'reprint_description' => 'Enter the box number to search and reprint its label:',
        'box_number_label' => 'Box No.:',
        'box_number_placeholder' => 'E.g: BOX001',
        'new_alert' => 'New Alert',
        'alert_type' => 'Alert Type',
        'alert_type_select' => 'Select a type',
        'alert_type_composition' => 'Composition',
        'alert_type_country' => 'Country of Manufacture',
        'alert_keywords' => 'Keywords',
        'alert_keywords_placeholder' => 'E.g: linen, linen (for composition) or Russia, Rusie, Belarus, Morocco (for country)',
        'alert_keywords_note' => 'Separate multiple keywords with commas. The search is case-insensitive and searches for partial matches.',
        'alert_description' => 'Description',
        'alert_description_placeholder' => 'E.g: Alert for products with linen',
        'alert_active' => 'Active alert',
        'add_new_article' => 'Add New Article',
        'barcode_not_found' => 'The barcode <strong>:barcode</strong> was not found. Please complete the details to add it as a new article.',
        'article_not_found' => 'The information for the selected article was not found.',
        'delete_confirm' => 'Delete article :barcode (MOCACO: :mocaco) from the box?',
        'invalid_box_container' => 'Invalid box number or Container to load content.',
        'loading_content' => 'Loading content for box :box...',
        'content_loaded' => 'Box :box content loaded: :count articles.',
        'box_dispatched' => 'This box is already dispatched.',
        'error_loading' => 'Error loading content.',
    ],
    
    'select2' => [
        'select_category' => 'Select a category',
        'select_family' => 'Select a family',
        'select_detail' => 'Search or select a detail',
        'select_season' => 'Select a season',
        'select_option' => 'Select...',
    ],
    
    'article_fields' => [
        'mocaco' => 'MOCACO:',
        'mocaco_note' => 'Will be automatically filled from the barcode.',
        'seccion' => 'Section:',
        'familia' => 'Family (Article Description):',
        'cadena' => 'Chain:',
        'mercado_origen' => 'Article Origin Market:',
        'precio_pvp' => 'Maximum Season PVP Price:',
        'partida_arancelaria' => 'Tariff Heading:',
        'composition' => 'Composition:',
        'campana' => 'Campaign:',
        'peso_unitario' => 'Unit Weight:',
        'grupo_arancelario' => 'Tariff Group:',
    ],
    
    'display' => [
        'total_units' => 'TOTAL UNITS (for this box):',
        'operator' => 'Operator:',
        'delete_item_title' => 'Delete this article from the box',
    ],
];

