@extends('layouts.app')

@section('title', 'Revisión de Artículos Sin Información')

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2><i class="fas fa-clipboard-check"></i> Revisión de Artículos Sin Información</h2>
    </div>

    @if (session('success'))
        <div class="alert alert-success alert-dismissible fade show mb-4" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if (session('error'))
        <div class="alert alert-danger alert-dismissible fade show mb-4" role="alert">
            {{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <!-- Filtros -->
    <div class="card mb-4">
        <div class="card-header">
            <h5><i class="fas fa-filter"></i> Filtros</h5>
        </div>
        <div class="card-body">
            <form method="GET" action="{{ route('article-review.index') }}">
                <div class="row">
                    <div class="col-md-3">
                        <label class="form-label">Contenedor</label>
                        <input type="text" name="conteneur" class="form-control" value="{{ request('conteneur') }}"
                            placeholder="Ej: CAMION-001">
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">Mocaco</label>
                        <input type="text" name="mocaco" class="form-control" value="{{ request('mocaco') }}"
                            placeholder="Ej: 0014110712">
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">Caja</label>
                        <input type="text" name="n_carton" class="form-control" value="{{ request('n_carton') }}"
                            placeholder="Ej: CAJA-001">
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">Desde</label>
                        <input type="date" name="date_from" class="form-control" value="{{ request('date_from') }}">
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">Hasta</label>
                        <input type="date" name="date_to" class="form-control" value="{{ request('date_to') }}">
                    </div>
                </div>
                <div class="mt-3">
                    <button type="submit" class="btn btn-primary"><i class="fas fa-search"></i> Buscar</button>
                    <a href="{{ route('article-review.index') }}" class="btn btn-secondary"><i class="fas fa-times"></i>
                        Limpiar</a>
                </div>
            </form>
        </div>
    </div>

    <!-- Lista de Artículos -->
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5><i class="fas fa-list"></i> Artículos Pendientes de Revisión</h5>
            <span class="badge bg-warning text-dark">{{ $articlesNeedingReview->total() }} artículos</span>
        </div>
        <div class="card-body">
            @if ($articlesNeedingReview->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Mocaco</th>
                                <th>Código de Barras</th>
                                <th>Caja</th>
                                <th>Contenedor</th>
                                <th>Fecha Escaneo</th>
                                <th>Operario</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($articlesNeedingReview as $item)
                                <tr>
                                    <td><code>{{ $item->mocaco }}</code></td>
                                    <td>{{ $item->full_barcode }}</td>
                                    <td>{{ $item->n_carton }}</td>
                                    <td>{{ $item->conteneur }}</td>
                                    <td>{{ $item->fecha_escaneo ? $item->fecha_escaneo->format('d/m/Y H:i') : '-' }}</td>
                                    <td>{{ $item->n_id_operario }}</td>
                                    <td>
                                        <button type="button" class="btn btn-sm btn-primary"
                                            onclick="reviewArticle({{ $item->id }}, '{{ $item->mocaco }}')">
                                            <i class="fas fa-edit"></i> Revisar
                                        </button>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <div class="mt-3">
                    {{ $articlesNeedingReview->links() }}
                </div>
            @else
                <div class="alert alert-info">
                    <i class="fas fa-info-circle"></i> No hay artículos pendientes de revisión.
                </div>
            @endif
        </div>
    </div>

    <!-- Modal de Revisión -->
    <div class="modal fade" id="reviewModal" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Revisar Artículo</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div id="loadingSuggestions" class="text-center">
                        <div class="spinner-border" role="status">
                            <span class="visually-hidden">Cargando...</span>
                        </div>
                        <p>Buscando sugerencias...</p>
                    </div>

                    <div id="reviewContent" style="display: none;">
                        <div class="alert alert-info">
                            <strong>Mocaco:</strong> <span id="reviewMocaco"></span>
                        </div>

                        <div id="suggestionsContainer"></div>

                        <hr>

                        <h6>Actualizar Información</h6>
                        <form id="reviewForm" method="POST">
                            @csrf
                            <input type="hidden" id="inventoryId" name="inventory_id">
                            <input type="hidden" id="hiddenMocaco" name="mocaco">

                            <!-- Checkbox para actualización masiva -->
                            <div class="alert alert-warning py-2 mb-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="applyToAll">
                                    <label class="form-check-label" for="applyToAll">
                                        <strong>Aplicar cambios a TODOS los artículos pendientes con este MOCACO</strong>
                                    </label>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Sección</label>
                                    <input type="text" name="seccion" id="seccion" class="form-control">
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Familia</label>
                                    <input type="text" name="familia" id="familia" class="form-control">
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Cadena</label>
                                    <input type="text" name="cadena" id="cadena" class="form-control">
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Mercado Origen</label>
                                    <input type="text" name="mercado_origen_articulo" id="mercado_origen_articulo"
                                        class="form-control">
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Precio PVP</label>
                                    <input type="number" step="0.01" name="precio_pvp_maximo_temporada"
                                        id="precio_pvp_maximo_temporada" class="form-control">
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Peso Unitario</label>
                                    <input type="number" step="0.001" name="peso_unitario" id="peso_unitario"
                                        class="form-control">
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Partida Arancelaria</label>
                                    <input type="text" name="partida_arancelaria" id="partida_arancelaria"
                                        class="form-control">
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Grupo Arancelario</label>
                                    <input type="text" name="grupo_arancelario" id="grupo_arancelario"
                                        class="form-control">
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Campaña</label>
                                    <input type="text" name="campana" id="campana" class="form-control">
                                </div>
                                <div class="col-md-12 mb-3">
                                    <label class="form-label">Composición</label>
                                    <textarea name="composition" id="composition" class="form-control" rows="2"></textarea>
                                </div>
                                <div class="col-md-12 mb-3">
                                    <label class="form-label">Notas de Revisión</label>
                                    <textarea name="review_notes" id="review_notes" class="form-control" rows="2"></textarea>
                                </div>
                            </div>

                            <div class="d-flex justify-content-end gap-2">
                                <button type="button" class="btn btn-secondary"
                                    data-bs-dismiss="modal">Cancelar</button>
                                <button type="submit" class="btn btn-success">
                                    <i class="fas fa-check"></i> Confirmar y Actualizar
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection

@push('scripts')
    <script>
        let currentInventoryId = null;
        const applyToAllCheckbox = document.getElementById('applyToAll');
        const reviewForm = document.getElementById('reviewForm');

        function reviewArticle(inventoryId, mocaco) {
            currentInventoryId = inventoryId;

            // Reset UI
            if (applyToAllCheckbox) {
                applyToAllCheckbox.checked = false;
            }
            document.getElementById('hiddenMocaco').value = mocaco;
            updateFormAction(inventoryId);

            // Mostrar modal
            const modal = new bootstrap.Modal(document.getElementById('reviewModal'));
            modal.show();

            // Mostrar loading
            document.getElementById('loadingSuggestions').style.display = 'block';
            document.getElementById('reviewContent').style.display = 'none';

            // Cargar sugerencias
            fetch(`/article-review/${inventoryId}/suggestions`)
                .then(response => response.json())
                .then(data => {
                    document.getElementById('loadingSuggestions').style.display = 'none';
                    document.getElementById('reviewContent').style.display = 'block';

                    document.getElementById('reviewMocaco').textContent = mocaco;
                    document.getElementById('inventoryId').value = inventoryId;

                    // Mostrar sugerencias
                    displaySuggestions(data.suggestions);
                })
                .catch(error => {
                    console.error('Error:', error);
                    alert('Error al cargar sugerencias');
                });
        }

        function updateFormAction(inventoryId) {
            if (!inventoryId) inventoryId = document.getElementById('inventoryId').value;

            if (applyToAllCheckbox && applyToAllCheckbox.checked) {
                reviewForm.action = "{{ route('article-review.bulk-update') }}"; // Blade renders this url
            } else {
                reviewForm.action = `/article-review/${inventoryId}/update`;
            }
        }

        if (applyToAllCheckbox) {
            applyToAllCheckbox.addEventListener('change', () => updateFormAction());
        }

        function displaySuggestions(suggestions) {
            const container = document.getElementById('suggestionsContainer');

            if (suggestions.length === 0) {
                container.innerHTML =
                    '<div class="alert alert-warning">No se encontraron sugerencias para este artículo.</div>';
                return;
            }

            let html = '<h6>Sugerencias Disponibles:</h6><div class="row">';

            suggestions.forEach((suggestion, index) => {
                const confidenceBadge = suggestion.confidence === 'high' ? 'bg-success' : 'bg-info';
                const sourceLabel = suggestion.source === 'article_master' ? 'Base de Artículos' :
                    'Histórico de Inventario';

                html += `
            <div class="col-md-6 mb-3">
                <div class="card border-primary">
                    <div class="card-header d-flex justify-content-between">
                        <span><i class="fas fa-lightbulb"></i> ${sourceLabel}</span>
                        <span class="badge ${confidenceBadge}">${suggestion.confidence}</span>
                    </div>
                    <div class="card-body">
                        <small>
                            <strong>Sección:</strong> ${suggestion.data.seccion || '-'}<br>
                            <strong>Familia:</strong> ${suggestion.data.familia || '-'}<br>
                            <strong>Cadena:</strong> ${suggestion.data.cadena || '-'}<br>
                            <strong>Mercado:</strong> ${suggestion.data.mercado_origen_articulo || '-'}<br>
                            <strong>Precio:</strong> ${suggestion.data.precio_pvp_maximo_temporada || '-'}<br>
                            <strong>Peso:</strong> ${suggestion.data.peso_unitario || '-'}
                        </small>
                        <button type="button" class="btn btn-sm btn-primary mt-2 w-100" onclick='applySuggestion(${JSON.stringify(suggestion.data)})'>
                            <i class="fas fa-check"></i> Aplicar Esta Sugerencia
                        </button>
                    </div>
                </div>
            </div>
        `;
            });

            html += '</div>';
            container.innerHTML = html;
        }

        function applySuggestion(data) {
            document.getElementById('seccion').value = data.seccion || '';
            document.getElementById('familia').value = data.familia || '';
            document.getElementById('cadena').value = data.cadena || '';
            document.getElementById('mercado_origen_articulo').value = data.mercado_origen_articulo || '';
            document.getElementById('precio_pvp_maximo_temporada').value = data.precio_pvp_maximo_temporada || '';
            document.getElementById('peso_unitario').value = data.peso_unitario || '';
            document.getElementById('partida_arancelaria').value = data.partida_arancelaria || '';
            document.getElementById('grupo_arancelario').value = data.grupo_arancelario || '';
            document.getElementById('campana').value = data.campana || '';
            document.getElementById('composition').value = data.composition || '';
        }
    </script>
@endpush
