@extends('layouts.app')

@section('title', 'Agregar Artículo')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-plus"></i> Agregar Artículo</h2>
    <a href="{{ route('articles.index') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Volver
    </a>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5><i class="fas fa-edit"></i> Información del Artículo</h5>
            </div>
            <div class="card-body">
                <form method="POST" action="{{ route('articles.store') }}">
                    @csrf
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="mocaco">MOCACO *</label>
                                <input type="text" class="form-control" id="mocaco" name="mocaco" 
                                       value="{{ old('mocaco') }}" required>
                                @error('mocaco')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="seccion">Sección</label>
                                <input type="text" class="form-control" id="seccion" name="seccion" 
                                       value="{{ old('seccion') }}">
                                @error('seccion')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="familia">Familia</label>
                                <input type="text" class="form-control" id="familia" name="familia" 
                                       value="{{ old('familia') }}">
                                @error('familia')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="cadena">Cadena</label>
                                <input type="text" class="form-control" id="cadena" name="cadena" 
                                       value="{{ old('cadena') }}">
                                @error('cadena')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="mercado_origen_articulo">Mercado Origen</label>
                                <input type="text" class="form-control" id="mercado_origen_articulo" name="mercado_origen_articulo" 
                                       value="{{ old('mercado_origen_articulo') }}">
                                @error('mercado_origen_articulo')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="precio_pvp_maximo_temporada">Precio PVP Máximo</label>
                                <input type="number" step="0.01" class="form-control" id="precio_pvp_maximo_temporada" 
                                       name="precio_pvp_maximo_temporada" value="{{ old('precio_pvp_maximo_temporada') }}">
                                @error('precio_pvp_maximo_temporada')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="partida_arancelaria">Partida Arancelaria</label>
                                <input type="text" class="form-control" id="partida_arancelaria" name="partida_arancelaria" 
                                       value="{{ old('partida_arancelaria') }}">
                                @error('partida_arancelaria')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="campana">Campaña</label>
                                <input type="text" class="form-control" id="campana" name="campana" 
                                       value="{{ old('campana') }}">
                                @error('campana')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="peso_unitario">Peso Unitario</label>
                                <input type="number" step="0.001" class="form-control" id="peso_unitario" 
                                       name="peso_unitario" value="{{ old('peso_unitario') }}">
                                @error('peso_unitario')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="grupo_arancelario">Grupo Arancelario</label>
                                <input type="text" class="form-control" id="grupo_arancelario" name="grupo_arancelario" 
                                       value="{{ old('grupo_arancelario') }}">
                                @error('grupo_arancelario')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="composition">Composición</label>
                        <textarea class="form-control" id="composition" name="composition" rows="3">{{ old('composition') }}</textarea>
                        @error('composition')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="d-flex justify-content-end gap-2">
                        <a href="{{ route('articles.index') }}" class="btn btn-secondary">
                            <i class="fas fa-times"></i> Cancelar
                        </a>
                        <button type="submit" class="btn">
                            <i class="fas fa-save"></i> Guardar Artículo
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5><i class="fas fa-info-circle"></i> Información</h5>
            </div>
            <div class="card-body">
                <p class="text-muted">
                    <strong>Campos obligatorios:</strong> Los campos marcados con (*) son obligatorios.
                </p>
                <p class="text-muted">
                    <strong>MOCACO:</strong> Código único del artículo.
                </p>
                <p class="text-muted">
                    <strong>Familia:</strong> Categoría principal del artículo.
                </p>
                <p class="text-muted">
                    <strong>Cadena:</strong> Marca o cadena comercial.
                </p>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
// Auto-focus en el primer campo
document.addEventListener('DOMContentLoaded', function() {
    document.getElementById('mocaco').focus();
});
</script>
@endpush

@push('styles')
<style>
.form-control {
    border: 1px solid var(--sap-border-color);
    border-radius: 4px;
    padding: 10px;
    font-size: 0.9em;
    transition: border-color 0.2s, box-shadow 0.2s;
}

.form-control:focus {
    border-color: var(--sap-blue-light);
    outline: none;
    box-shadow: 0 0 0 2px rgba(52, 152, 219, 0.2);
}

.text-danger {
    font-size: 0.8em;
    margin-top: 5px;
}

.gap-2 {
    gap: 10px;
}
</style>
@endpush
