@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-gray-800">Nueva Marca</h1>
        <a href="{{ route('brands.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Volver
        </a>
    </div>

    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Información de la Marca</h6>
        </div>
        <div class="card-body">
            <form action="{{ route('brands.store') }}" method="POST">
                @csrf

                <div class="mb-3">
                    <label for="name" class="form-label">Nombre Oficial <span class="text-danger">*</span></label>
                    <input type="text" class="form-control @error('name') is-invalid @enderror" id="name" name="name" value="{{ old('name') }}" required placeholder="Ej: Pull&Bear">
                    @error('name')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                    <small class="form-text text-muted">Este es el nombre único y correcto que se usará en el sistema.</small>
                </div>

                <div class="mb-3">
                    <label for="aliases" class="form-label">Alias / Variaciones</label>
                    <input type="text" class="form-control @error('aliases') is-invalid @enderror" id="aliases" name="aliases" value="{{ old('aliases') }}" placeholder="Ej: Pullandbear, Pull & Bear, P&B">
                    @error('aliases')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                    <small class="form-text text-muted">Ingrese variaciones separadas por comas. El sistema convertirá automáticamente estas variaciones al nombre oficial durante la importación.</small>
                </div>

                <div class="mb-3">
                    <label for="description" class="form-label">Descripción</label>
                    <textarea class="form-control @error('description') is-invalid @enderror" id="description" name="description" rows="3">{{ old('description') }}</textarea>
                    @error('description')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="d-flex justify-content-end">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> Guardar Marca
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
