@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-gray-800">Maestro de Marcas</h1>
        <a href="{{ route('brands.create') }}" class="btn btn-primary">
            <i class="fas fa-plus"></i> Nueva Marca
        </a>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif

    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Listado de Marcas</h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" id="brandsTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>Nombre Oficial</th>
                            <th>Alias (Variaciones)</th>
                            <th>Descripción</th>
                            <th>Estado</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($brands as $brand)
                            <tr>
                                <td class="font-weight-bold">{{ $brand->name }}</td>
                                <td>
                                    @if($brand->aliases)
                                        @foreach($brand->aliases as $alias)
                                            <span class="badge bg-secondary">{{ $alias }}</span>
                                        @endforeach
                                    @else
                                        <span class="text-muted small">Sin alias</span>
                                    @endif
                                </td>
                                <td>{{ Str::limit($brand->description, 50) }}</td>
                                <td>
                                    @if($brand->is_active)
                                        <span class="badge bg-success">Activo</span>
                                    @else
                                        <span class="badge bg-danger">Inactivo</span>
                                    @endif
                                </td>
                                <td>
                                    <div class="btn-group" role="group">
                                        <a href="{{ route('brands.edit', $brand) }}" class="btn btn-sm btn-info" title="Editar">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <form action="{{ route('brands.destroy', $brand) }}" method="POST" class="d-inline" onsubmit="return confirm('¿Está seguro de eliminar esta marca?');">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-danger" title="Eliminar">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="text-center py-4">
                                    <div class="text-muted">No hay marcas registradas.</div>
                                    <a href="{{ route('brands.create') }}" class="mt-2 btn btn-sm btn-primary">Crear primera marca</a>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            <div class="mt-3">
                {{ $brands->links() }}
            </div>
        </div>
    </div>
</div>
@endsection
