@extends('layouts.app')

@section('title', 'Detalle del Cliente')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-eye"></i> Detalle del Cliente</h2>
    <div class="d-flex gap-2">
        @can('clients.update')
        <a href="{{ route('clients.edit', $client) }}" class="btn">
            <i class="fas fa-edit"></i> Editar
        </a>
        @endcan
        <a href="{{ route('clients.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Volver
        </a>
    </div>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5><i class="fas fa-info-circle"></i> Información Principal</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="info-group">
                            <label>Nombre</label>
                            <p>{{ $client->name }}</p>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="info-group">
                            <label>Email</label>
                            <p>{{ $client->email }}</p>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="info-group">
                            <label>Teléfono</label>
                            <p>{{ $client->phone ?? '-' }}</p>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="info-group">
                            <label>Empresa</label>
                            <p>{{ $client->company ?? '-' }}</p>
                        </div>
                    </div>
                </div>

                @if($client->address)
                <div class="info-group">
                    <label>Dirección</label>
                    <p>{{ $client->address }}</p>
                </div>
                @endif

                <div class="row">
                    <div class="col-md-4">
                        <div class="info-group">
                            <label>Ciudad</label>
                            <p>{{ $client->city ?? '-' }}</p>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="info-group">
                            <label>País</label>
                            <p>{{ $client->country ?? '-' }}</p>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="info-group">
                            <label>Código Postal</label>
                            <p>{{ $client->postal_code ?? '-' }}</p>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="info-group">
                            <label>Estado</label>
                            <p>
                                <span class="badge badge-{{ $client->status === 'active' ? 'success' : 'secondary' }}">
                                    {{ ucfirst($client->status) }}
                                </span>
                            </p>
                        </div>
                    </div>
                </div>

                @if($client->notes)
                <div class="info-group">
                    <label>Notas</label>
                    <p>{{ $client->notes }}</p>
                </div>
                @endif
            </div>
        </div>

        @if($client->orders && $client->orders->count() > 0)
        <div class="card mt-3">
            <div class="card-header">
                <h5><i class="fas fa-shopping-cart"></i> Pedidos del Cliente</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-sm">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Estado</th>
                                <th>Fecha</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($client->orders->take(5) as $order)
                                <tr>
                                    <td>{{ $order->id }}</td>
                                    <td>
                                        <span class="badge badge-{{ $order->status === 'dispatched' ? 'success' : ($order->status === 'cancelled' ? 'danger' : 'warning') }}">
                                            {{ ucfirst($order->status) }}
                                        </span>
                                    </td>
                                    <td>{{ $order->created_at->format('d/m/Y') }}</td>
                                    <td>
                                        <a href="{{ route('orders.show', $order) }}" class="btn btn-sm btn-outline-info">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                @if($client->orders->count() > 5)
                    <div class="text-center mt-2">
                        <a href="{{ route('orders.index', ['client_id' => $client->id]) }}" class="btn btn-sm">
                            Ver todos los pedidos ({{ $client->orders->count() }})
                        </a>
                    </div>
                @endif
            </div>
        </div>
        @endif
    </div>

    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5><i class="fas fa-clock"></i> Información Temporal</h5>
            </div>
            <div class="card-body">
                <div class="info-group">
                    <label>ID del Cliente</label>
                    <p><strong>{{ $client->id }}</strong></p>
                </div>
                
                <div class="info-group">
                    <label>Creado</label>
                    <p>{{ $client->created_at->format('d/m/Y H:i:s') }}</p>
                </div>
                
                <div class="info-group">
                    <label>Última Actualización</label>
                    <p>{{ $client->updated_at->format('d/m/Y H:i:s') }}</p>
                </div>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h5><i class="fas fa-cogs"></i> Acciones</h5>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <a href="{{ route('clients.edit', $client) }}" class="btn">
                        <i class="fas fa-edit"></i> Editar Cliente
                    </a>
                    
                    <a href="{{ route('orders.create', ['client_id' => $client->id]) }}" class="btn btn-outline-primary">
                        <i class="fas fa-plus"></i> Nuevo Pedido
                    </a>
                    
                    <form action="{{ route('clients.destroy', $client) }}" method="POST" 
                          onsubmit="return confirm('¿Está seguro de eliminar este cliente?')">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger w-100">
                            <i class="fas fa-trash"></i> Eliminar Cliente
                        </button>
                    </form>
                </div>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h5><i class="fas fa-chart-bar"></i> Estadísticas</h5>
            </div>
            <div class="card-body">
                <div class="stat-item">
                    <span class="stat-label">Total Pedidos:</span>
                    <span class="stat-value">{{ $client->orders ? $client->orders->count() : 0 }}</span>
                </div>
                <div class="stat-item">
                    <span class="stat-label">Pedidos Activos:</span>
                    <span class="stat-value">{{ $client->orders ? $client->orders->where('status', '!=', 'cancelled')->count() : 0 }}</span>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
.info-group {
    margin-bottom: 20px;
}

.info-group label {
    font-weight: 600;
    color: var(--sap-text-medium);
    font-size: 0.9em;
    margin-bottom: 5px;
    display: block;
}

.info-group p {
    margin: 0;
    padding: 8px 12px;
    background-color: #f8f9fa;
    border-radius: 4px;
    border-left: 3px solid var(--sap-blue-light);
    font-size: 0.95em;
}

.badge {
    padding: 0.5em 0.75em;
    font-size: 0.75em;
    font-weight: 700;
    line-height: 1;
    text-align: center;
    white-space: nowrap;
    vertical-align: baseline;
    border-radius: 0.375rem;
}

.badge-success {
    background-color: #28a745;
    color: white;
}

.badge-secondary {
    background-color: #6c757d;
    color: white;
}

.badge-warning {
    background-color: #ffc107;
    color: #212529;
}

.badge-danger {
    background-color: #dc3545;
    color: white;
}

.gap-2 {
    gap: 10px;
}

.d-grid {
    display: grid;
}

.btn-outline-primary {
    background-color: transparent;
    color: var(--sap-blue-light);
    border: 1px solid var(--sap-blue-light);
}

.btn-outline-primary:hover {
    background-color: var(--sap-blue-light);
    color: white;
}

.w-100 {
    width: 100%;
}

.stat-item {
    display: flex;
    justify-content: space-between;
    margin-bottom: 10px;
}

.stat-label {
    color: var(--sap-text-medium);
}

.stat-value {
    font-weight: bold;
    color: var(--sap-blue-light);
}
</style>
@endpush

