@extends('layouts.app')

@section('title', __('config.edit.title'))

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-edit"></i> {{ __('config.edit.title') }}</h2>
    <a href="{{ route('config.index') }}" class="btn btn-secondary"><i class="fas fa-arrow-left"></i> {{ __('config.edit.back') }}</a>
</div>

<div class="card">
    <div class="card-body">
        <form method="POST" action="{{ route('config.update', $config) }}">
            @csrf
            @method('PUT')
            <div class="mb-3">
                <label class="form-label">{{ __('config.form.key_label') }}</label>
                <input type="text" name="key" class="form-control" value="{{ old('key', $config->key) }}" required>
                @error('key')
                    <div class="text-danger small">{{ $message }}</div>
                @enderror
            </div>
            <div class="mb-3">
                <label class="form-label">{{ __('config.form.value_label') }}</label>
                <textarea name="value" rows="6" class="form-control">{{ old('value', $config->value) }}</textarea>
                @error('value')
                    <div class="text-danger small">{{ $message }}</div>
                @enderror
            </div>
            <button class="btn btn-primary" type="submit"><i class="fas fa-save"></i> {{ __('config.edit.submit') }}</button>
        </form>
    </div>
@endsection


