@extends('layouts.app')

@section('title', __('config.index.title'))

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-sliders-h"></i> {{ __('config.index.title') }}</h2>
    <a href="{{ route('config.create') }}" class="btn btn-primary">
        <i class="fas fa-plus"></i> {{ __('config.index.new_parameter') }}
    </a>
    </div>

@if(session('success'))
<div class="alert alert-success alert-dismissible fade show mb-4" role="alert">
    {{ session('success') }}
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
</div>
@endif

<div class="card">
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-striped mb-0">
                <thead>
                    <tr>
                        <th style="width: 40%">{{ __('config.index.columns.key') }}</th>
                        <th>{{ __('config.index.columns.value') }}</th>
                        <th style="width: 180px">{{ __('config.index.columns.actions') }}</th>
                    </tr>
                </thead>
                <tbody>
                @forelse($configs as $item)
                    <tr>
                        <td><code>{{ $item->key }}</code></td>
                        <td style="white-space: pre-wrap">{{ Str::limit($item->value, 180) }}</td>
                        <td>
                            <div class="btn-group" role="group">
                                <a href="{{ route('config.show', $item) }}" class="btn btn-sm btn-outline-secondary">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <a href="{{ route('config.edit', $item) }}" class="btn btn-sm btn-outline-primary">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <form action="{{ route('config.destroy', $item) }}" method="POST" onsubmit="return confirm('{{ __('config.messages.delete_confirm') }}');">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-outline-danger">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                @empty
                    <tr><td colspan="3" class="text-center text-muted p-4">{{ __('config.index.empty') }}</td></tr>
                @endforelse
                </tbody>
            </table>
        </div>
    </div>
    @if($configs->hasPages())
    <div class="card-footer">{{ $configs->links() }}</div>
    @endif
</div>
@endsection


