@extends('layouts.app')

@section('title', __('container_entries.edit.title', ['id' => $containerEntry->id]))

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-edit"></i> {{ __('container_entries.edit.title', ['id' => $containerEntry->id]) }}</h2>
    <a href="{{ route('container-entries.show', $containerEntry) }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> {{ __('container_entries.common.back') }}
    </a>
</div>

<div class="card">
    <div class="card-body">
        <form method="POST" action="{{ route('container-entries.update', $containerEntry) }}">
            @csrf
            @method('PUT')
            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label class="form-label">{{ __('container_entries.form.truck_label') }} <span class="text-danger">*</span></label>
                        <input type="text" name="n_camion" class="form-control @error('n_camion') is-invalid @enderror" 
                               value="{{ old('n_camion', $containerEntry->n_camion) }}" required>
                        @error('n_camion')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="mb-3">
                        <label class="form-label">{{ __('container_entries.form.brand') }}</label>
                        <input type="text" name="marca" class="form-control" value="{{ old('marca', $containerEntry->marca) }}">
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label class="form-label">{{ __('container_entries.form.product_type') }}</label>
                        <input type="text" name="tipo_producto" class="form-control" value="{{ old('tipo_producto', $containerEntry->tipo_producto) }}">
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="mb-3">
                        <label class="form-label">{{ __('container_entries.form.assigned_user') }}</label>
                        <select name="usuario_asignado_id" class="form-select">
                            <option value="">{{ __('container_entries.form.assigned_user_placeholder') }}</option>
                            @foreach($users as $user)
                                <option value="{{ $user->id }}" {{ old('usuario_asignado_id', $containerEntry->usuario_asignado_id) == $user->id ? 'selected' : '' }}>
                                    {{ $user->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>
            </div>
            <div class="mb-3">
                <label class="form-label">{{ __('container_entries.form.notes') }}</label>
                <textarea name="notes" class="form-control" rows="3">{{ old('notes', $containerEntry->notes) }}</textarea>
            </div>
            <button type="submit" class="btn btn-primary"><i class="fas fa-save"></i> {{ __('container_entries.edit.submit') }}</button>
        </form>
    </div>
</div>
@endsection

