@extends('layouts.app')

@section('title', __('container_entries.show.title', ['id' => $containerEntry->id, 'truck' =>
    $containerEntry->n_camion]))

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2><i class="fas fa-truck"></i>
            {{ __('container_entries.show.title', ['id' => $containerEntry->id, 'truck' => $containerEntry->n_camion]) }}
        </h2>
        <div>
            @if ($containerEntry->estado->isEnProceso())
                @if (Auth::user()->hasRole('admin'))
                    <form action="{{ route('container-entries.finalize', $containerEntry) }}" method="POST" class="d-inline"
                        onsubmit="return confirm('{{ __('container_entries.show.finalize_confirm') }}');">
                        @csrf
                        <button type="submit" class="btn btn-success"><i class="fas fa-check"></i>
                            {{ __('container_entries.show.finalize') }}</button>
                    </form>
                    @php
                        $discrepancyReport = session('discrepancy_report');
                    @endphp
                    @if ($discrepancyReport && ($discrepancyReport['total_discrepancias'] ?? 0) > 0)
                        <form action="{{ route('container-entries.finalize', $containerEntry) }}" method="POST"
                            class="d-inline"
                            onsubmit="return confirm('{{ __('container_entries.show.force_finalize_confirm') }}');">
                            @csrf
                            <input type="hidden" name="force" value="1">
                            <button type="submit" class="btn btn-warning"><i class="fas fa-exclamation-triangle"></i>
                                {{ __('container_entries.show.force_finalize') }}</button>
                        </form>
                    @endif
                @endif
            @endif
            <a href="{{ route('container-entries.index') }}" class="btn btn-secondary"><i class="fas fa-arrow-left"></i>
                {{ __('container_entries.common.back') }}</a>
        </div>
    </div>

    @if (session('success'))
        <div class="alert alert-success alert-dismissible fade show mb-4" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if (session('warning'))
        <div class="alert alert-warning alert-dismissible fade show mb-4" role="alert">
            <i class="fas fa-exclamation-triangle"></i> {{ session('warning') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @php
        $discrepancyReport = session('discrepancy_report');
    @endphp

    @if (session('error'))
        <div class="alert alert-danger alert-dismissible fade show mb-4" role="alert">
            <h5><i class="fas fa-exclamation-circle"></i> {{ __('container_entries.show.alerts.error_title') }}</h5>
            <p>{{ session('error') }}</p>
            @if ($discrepancyReport && ($discrepancyReport['total_discrepancias'] ?? 0) > 0)
                <p class="mt-2 mb-0">
                    <strong>{{ __('container_entries.show.alerts.discrepancy_total') }}</strong>
                    {{ $discrepancyReport['total_discrepancias'] }}.
                    {{ __('container_entries.show.alerts.force_info') }}
                </p>
            @endif
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif

    @if ($discrepancyReport && ($discrepancyReport['total_discrepancias'] ?? 0) > 0 && !session('error'))
        <div class="alert alert-warning alert-dismissible fade show mb-4" role="alert">
            <h5><i class="fas fa-exclamation-triangle"></i> {{ __('container_entries.show.alerts.discrepancies_found') }}
            </h5>
            <p><strong>{{ __('container_entries.show.alerts.discrepancy_total') }}</strong>
                {{ $discrepancyReport['total_discrepancias'] }}</p>
            @if (isset($discrepancyReport['summary']))
                <p class="mb-0">
                    <strong>{{ __('container_entries.show.alerts.summary') }}</strong>
                    {{ __('container_entries.show.alerts.total_theoretical') }}
                    {{ $discrepancyReport['summary']['total_teorico'] }} |
                    {{ __('container_entries.show.alerts.total_scanned') }}
                    {{ $discrepancyReport['summary']['total_escaneado'] }}
                </p>
            @endif
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="row">
        <!-- Información Principal -->
        <div class="col-md-6">
            <div class="card mb-4">
                <div class="card-header">
                    <h5><i class="fas fa-info-circle"></i> {{ __('container_entries.show.info_card') }}</h5>
                </div>
                <div class="card-body">
                    <table class="table table-borderless">
                        <tr>
                            <th width="40%">{{ __('container_entries.show.fields.truck_number') }}</th>
                            <td><strong>{{ $containerEntry->n_camion }}</strong></td>
                        </tr>
                        <tr>
                            <th>{{ __('container_entries.show.fields.status') }}</th>
                            <td>
                                <span
                                    class="badge badge-{{ $containerEntry->estado->isFinalizado() ? 'success' : 'warning' }}">
                                    {{ $containerEntry->estado->label() }}
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <th>{{ __('container_entries.show.fields.brand') }}</th>
                            <td>{{ $containerEntry->marca ?? '-' }}</td>
                        </tr>
                        <tr>
                            <th>{{ __('container_entries.show.fields.product_type') }}</th>
                            <td>{{ $containerEntry->tipo_producto ?? '-' }}</td>
                        </tr>
                        <tr>
                            <th>{{ __('container_entries.show.fields.assigned_user') }}</th>
                            <td>
                                @if ($containerEntry->usuarioAsignado)
                                    {{ $containerEntry->usuarioAsignado->name }}
                                    @if (Auth::user()->hasRole('admin'))
                                        <form action="{{ route('container-entries.assign-user', $containerEntry) }}"
                                            method="POST" class="d-inline mt-2">
                                            @csrf
                                            <select name="usuario_asignado_id"
                                                class="form-select form-select-sm d-inline-block" style="width: auto;"
                                                onchange="this.form.submit()">
                                                <option value="">
                                                    {{ __('container_entries.show.assign_user.change') }}</option>
                                                @foreach (\App\Models\User::all() as $user)
                                                    <option value="{{ $user->id }}">{{ $user->name }}</option>
                                                @endforeach
                                            </select>
                                        </form>
                                    @endif
                                @else
                                    <span class="text-muted">{{ __('container_entries.common.not_assigned') }}</span>
                                    @if (Auth::user()->hasRole('admin'))
                                        <form action="{{ route('container-entries.assign-user', $containerEntry) }}"
                                            method="POST" class="d-inline mt-2">
                                            @csrf
                                            <select name="usuario_asignado_id"
                                                class="form-select form-select-sm d-inline-block" style="width: auto;"
                                                onchange="this.form.submit()">
                                                <option value="">
                                                    {{ __('container_entries.show.assign_user.assign') }}</option>
                                                @foreach (\App\Models\User::all() as $user)
                                                    <option value="{{ $user->id }}">{{ $user->name }}</option>
                                                @endforeach
                                            </select>
                                        </form>
                                    @endif
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>{{ __('container_entries.show.fields.created_at') }}</th>
                            <td>{{ $containerEntry->created_at->format('d/m/Y H:i') }}</td>
                        </tr>
                        @if ($containerEntry->fecha_inicio_proceso)
                            <tr>
                                <th>{{ __('container_entries.show.fields.start_date') }}</th>
                                <td>{{ $containerEntry->fecha_inicio_proceso->format('d/m/Y H:i') }}</td>
                            </tr>
                        @endif
                        @if ($containerEntry->fecha_finalizacion)
                            <tr>
                                <th>{{ __('container_entries.show.fields.finish_date') }}</th>
                                <td>{{ $containerEntry->fecha_finalizacion->format('d/m/Y H:i') }}</td>
                            </tr>
                        @endif
                        @if ($cycleTime && $cycleTime['total_hours'])
                            <tr>
                                <th>{{ __('container_entries.show.fields.cycle_time') }}</th>
                                <td><strong>{{ $cycleTime['formatted'] }}</strong></td>
                            </tr>
                        @endif
                    </table>
                    @if ($containerEntry->notes)
                        <div class="mt-3">
                            <strong>{{ __('container_entries.show.fields.notes') }}</strong>
                            <p class="text-muted">{{ $containerEntry->notes }}</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- Progreso y Estadísticas -->
        <div class="col-md-6">
            <div class="card mb-4">
                <div class="card-header">
                    <h5><i class="fas fa-chart-line"></i> {{ __('container_entries.show.progress_card') }}</h5>
                </div>
                <div class="card-body">
                    @if ($progress)
                        <div class="text-center mb-3">
                            <h2 class="mb-0">{{ $progress['percentage'] }}%</h2>
                            <p class="text-muted">{{ __('container_entries.show.progress_completed') }}</p>
                        </div>
                        <div class="progress mb-3" style="height: 30px;">
                            <div class="progress-bar {{ $progress['percentage'] >= 100 ? 'bg-success' : 'bg-info' }}"
                                role="progressbar" style="width: {{ min(100, $progress['percentage']) }}%">
                            </div>
                        </div>
                        <table class="table table-sm">
                            <tr>
                                <th>{{ __('container_entries.show.progress_fields.theoretical_units') }}</th>
                                <td><strong>{{ $progress['theoretical_units'] }}</strong></td>
                            </tr>
                            <tr>
                                <th>{{ __('container_entries.show.progress_fields.scanned_units') }}</th>
                                <td><strong>{{ $progress['scanned_units'] }}</strong></td>
                            </tr>
                            <tr>
                                <th>{{ __('container_entries.show.progress_fields.remaining_units') }}</th>
                                <td><strong>{{ $progress['remaining_units'] }}</strong></td>
                            </tr>
                        </table>
                    @else
                        <p class="text-muted text-center">{{ __('container_entries.show.progress_empty') }}</p>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Carga de Artículos Teóricos -->
    <div class="card mb-4">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5><i class="fas fa-file-excel"></i> {{ __('container_entries.show.theoretical.title') }}</h5>
            <span
                class="badge bg-primary">{{ __('container_entries.show.theoretical.badge', ['count' => $containerEntry->theoreticalArticles->count()]) }}</span>
        </div>
        <div class="card-body">
            <form action="{{ route('container-entries.upload-theoretical', $containerEntry) }}" method="POST"
                enctype="multipart/form-data" class="mb-4">
                @csrf
                <div class="row">
                    <div class="col-md-8">
                        <label class="form-label">{{ __('container_entries.show.theoretical.upload_label') }}</label>
                        <input type="file" name="file" class="form-control" accept=".xlsx,.xls,.csv" required>
                        <small class="text-muted">{{ __('container_entries.show.theoretical.upload_help') }}</small>
                    </div>
                    <div class="col-md-4 d-flex align-items-end">
                        <div class="mb-2"></div>
                    </div>
                </div>
                <button type="submit" class="btn btn-primary mt-2"><i class="fas fa-upload"></i>
                    {{ __('container_entries.show.theoretical.upload_button') }}</button>
            </form>

            @if(isset($latestImport))
                <div id="import-status-container" class="mb-4">
                    <h6 class="border-bottom pb-2">Estado de la última importación: <span class="badge bg-secondary">{{ $latestImport->created_at->format('d/m/Y H:i') }}</span></h6>

                    @if($latestImport->status === 'failed')
                        <div class="alert alert-danger">
                            <h5><i class="fas fa-times-circle"></i> Error en la importación</h5>
                            <p class="mb-0">{{ $latestImport->error_message }}</p>
                        </div>
                    @elseif($latestImport->status === 'completed')
                        <div class="alert alert-success">
                            <h5><i class="fas fa-check-circle"></i> Importación completada</h5>
                            <ul class="mb-0">
                                <li>Total filas: {{ $latestImport->total_rows }}</li>
                                <li>Importados: {{ $latestImport->imported_rows }}</li>
                                <li>Omitidos: {{ $latestImport->skipped_rows }}</li>
                            </ul>
                        </div>
                    @else
                        <div class="alert alert-info">
                            <h5 id="import-status-title"><i class="fas fa-spinner fa-spin"></i> Procesando...</h5>
                            <div class="progress mb-2">
                                <div id="import-progress-bar" class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" style="width: {{ $latestImport->progress_percentage }}%"></div>
                            </div>
                            <small id="import-status-text">Procesando filas...</small>
                        </div>
                        <script>
                            document.addEventListener('DOMContentLoaded', function() {
                                checkImportProgress();
                            });

                            function checkImportProgress() {
                                fetch('{{ route("container-entries.import-progress", $containerEntry) }}?import_progress_id={{ $latestImport->id }}')
                                    .then(response => response.json())
                                    .then(data => {
                                        if (data.status === 'completed' || data.status === 'failed') {
                                            window.location.reload();
                                        } else {
                                            // Update bar
                                            document.getElementById('import-progress-bar').style.width = data.progress_percentage + '%';
                                            document.getElementById('import-status-text').innerText = `Procesando: ${data.processed_rows} / ${data.total_rows}`;
                                            setTimeout(checkImportProgress, 2000);
                                        }
                                    });
                            }
                        </script>
                    @endif
                </div>
            @endif

            @if ($containerEntry->theoreticalArticles->count() > 0)
                <div class="table-responsive">
                    <table class="table table-sm table-striped">
                        <thead>
                            <tr>
                                <th>{{ __('container_entries.show.theoretical.table_headers.mocaco') }}</th>
                                <th>{{ __('container_entries.show.theoretical.table_headers.units') }}</th>
                                <th>{{ __('container_entries.show.theoretical.table_headers.family') }}</th>
                                <th>{{ __('container_entries.show.theoretical.table_headers.section') }}</th>
                                <th>{{ __('container_entries.show.theoretical.table_headers.campaign') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($containerEntry->theoreticalArticles->take(10) as $theoretical)
                                <tr>
                                    <td><code>{{ $theoretical->mocaco }}</code></td>
                                    <td><strong>{{ $theoretical->cantidad_unidades }}</strong></td>
                                    <td>{{ $theoretical->familia_articulo_description ?? '-' }}</td>
                                    <td>{{ $theoretical->seccion ?? '-' }}</td>
                                    <td>{{ $theoretical->campana ?? '-' }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                    @if ($containerEntry->theoreticalArticles->count() > 10)
                        <p class="text-muted text-center">
                            {{ __('container_entries.show.theoretical.showing', ['shown' => 10, 'total' => $containerEntry->theoreticalArticles->count()]) }}
                        </p>
                    @endif
                </div>
            @else
                <p class="text-muted text-center">{{ __('container_entries.show.theoretical.empty') }}</p>
            @endif
        </div>
    </div>

    <!-- Carga Masiva de Inventario (Manual) -->
    <div class="card mb-4 border-info">
        <div class="card-header d-flex justify-content-between align-items-center bg-light">
            <h5 class="text-info"><i class="fas fa-boxes"></i> {{ __('Carga Masiva de Inventario (Manual)') }}</h5>
            <a href="{{ route('container-entries.inventory-template') }}" class="btn btn-sm btn-outline-info">
                <i class="fas fa-download"></i> {{ __('Descargar Plantilla') }}
            </a>
        </div>
        <div class="card-body">
            <div class="alert alert-info">
                <i class="fas fa-info-circle"></i>
                {{ __('Utilice esta opción para cargar inventario ya trabajado manualmente (Excel). Esto creará los artículos en el inventario directamente.') }}
            </div>
            <form action="{{ route('container-entries.upload-inventory', $containerEntry) }}" method="POST"
                enctype="multipart/form-data" class="mb-4">
                @csrf
                <div class="row">
                    <div class="col-md-8">
                        <label class="form-label">{{ __('Seleccionar archivo Excel de Inventario') }}</label>
                        <input type="file" name="file" class="form-control" accept=".xlsx,.xls,.csv" required>
                        <small
                            class="text-muted">{{ __('Columnas requeridas: mocaco. Opcionales: cantidad_unidades, full_barcode, n_carton, etc.') }}</small>
                    </div>
                    <div class="col-md-4 d-flex align-items-end">
                        <div class="mb-2"></div>
                    </div>
                </div>
                <button type="submit" class="btn btn-info mt-2 text-white"><i class="fas fa-upload"></i>
                    {{ __('Cargar Inventario Manual') }}</button>
            </form>
        </div>
    </div>

    <!-- Reporte de Discrepancias -->
    @php
        $showReport = $containerEntry->estado->isFinalizado() || session('discrepancy_report');
        $discrepancyReport = session('discrepancy_report');
        if (!$discrepancyReport && $containerEntry->estado->isFinalizado()) {
            // Si está finalizado, obtener el reporte actual
            $discrepancyReport = app(\App\Services\ContainerEntryService::class)->generateDiscrepancyReport(
                $containerEntry,
            );
        }
    @endphp

    @if ($showReport && $discrepancyReport)
        <div class="card mb-4">
            <div class="card-header">
                <h5><i class="fas fa-exclamation-triangle"></i> {{ __('container_entries.show.discrepancies.title') }}
                </h5>
            </div>
            <div class="card-body">
                @if (isset($discrepancyReport['summary']))
                    <div class="row mb-3">
                        <div class="col-md-3">
                            <strong>{{ __('container_entries.show.discrepancies.summary.total_theoretical') }}</strong>
                            {{ $discrepancyReport['summary']['total_teorico'] }}
                        </div>
                        <div class="col-md-3">
                            <strong>{{ __('container_entries.show.discrepancies.summary.total_scanned') }}</strong>
                            {{ $discrepancyReport['summary']['total_escaneado'] }}
                        </div>
                        <div class="col-md-3">
                            <strong>{{ __('container_entries.show.discrepancies.summary.missing') }}</strong> <span
                                class="text-danger">{{ abs($discrepancyReport['summary']['total_faltantes']) }}</span>
                        </div>
                        <div class="col-md-3">
                            <strong>{{ __('container_entries.show.discrepancies.summary.excess') }}</strong> <span
                                class="text-warning">{{ $discrepancyReport['summary']['total_excesos'] }}</span>
                        </div>
                    </div>
                @endif

                @if (isset($discrepancyReport['discrepancies']) && count($discrepancyReport['discrepancies']) > 0)
                    <div class="table-responsive mb-3" style="max-height: 400px; overflow-y: auto;">
                        <table class="table table-sm table-striped">
                            <thead class="table-light sticky-top">
                                <tr>
                                    <th>{{ __('container_entries.show.discrepancies.table_headers.mocaco') }}</th>
                                    <th>{{ __('container_entries.show.discrepancies.table_headers.theoretical') }}</th>
                                    <th>{{ __('container_entries.show.discrepancies.table_headers.scanned') }}</th>
                                    <th>{{ __('container_entries.show.discrepancies.table_headers.difference') }}</th>
                                    <th>{{ __('container_entries.show.discrepancies.table_headers.type') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach (array_slice($discrepancyReport['discrepancies'], 0, 20) as $disc)
                                    <tr>
                                        <td><code>{{ $disc['mocaco'] }}</code></td>
                                        <td>{{ $disc['unidades_teoricas'] }}</td>
                                        <td>{{ $disc['unidades_escaneadas'] }}</td>
                                        <td>
                                            @if ($disc['diferencia'] > 0)
                                                <span class="text-warning">+{{ $disc['diferencia'] }}</span>
                                            @else
                                                <span class="text-danger">{{ $disc['diferencia'] }}</span>
                                            @endif
                                        </td>
                                        <td>
                                            @switch($disc['tipo'])
                                                @case('faltante')
                                                    <span
                                                        class="badge bg-danger">{{ __('container_entries.show.discrepancies.types.faltante') }}</span>
                                                @break

                                                @case('exceso')
                                                    <span
                                                        class="badge bg-warning text-dark">{{ __('container_entries.show.discrepancies.types.exceso') }}</span>
                                                @break

                                                @case('no_esperado')
                                                    <span
                                                        class="badge bg-info">{{ __('container_entries.show.discrepancies.types.no_esperado') }}</span>
                                                @break
                                            @endswitch
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                        @if (count($discrepancyReport['discrepancies']) > 20)
                            <p class="text-muted text-center">
                                {{ __('container_entries.show.discrepancies.showing', ['shown' => 20, 'total' => count($discrepancyReport['discrepancies'])]) }}
                            </p>
                        @endif
                    </div>
                @else
                    <p class="text-success"><i class="fas fa-check-circle"></i>
                        {{ __('container_entries.show.discrepancies.none') }}</p>
                @endif

                <a href="{{ route('container-entries.discrepancy-report', $containerEntry) }}" class="btn btn-info">
                    <i class="fas fa-file-excel"></i> {{ __('container_entries.show.discrepancies.download') }}
                </a>
            </div>
        </div>
    @endif
@endsection
