@extends('layouts.app')

@section('title', 'Editar Item de Inventario')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-edit"></i> Editar Item de Inventario</h2>
    <a href="{{ route('inventory.index') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Volver
    </a>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5><i class="fas fa-edit"></i> Información del Item</h5>
            </div>
            <div class="card-body">
                <form method="POST" action="{{ route('inventory.update', $inventory) }}">
                    @csrf
                    @method('PUT')
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="full_barcode">Código de Barras *</label>
                                <input type="text" class="form-control" id="full_barcode" name="full_barcode" 
                                       value="{{ old('full_barcode', $inventory->full_barcode) }}" required>
                                @error('full_barcode')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="mocaco">MOCACO *</label>
                                <input type="text" class="form-control" id="mocaco" name="mocaco" 
                                       value="{{ old('mocaco', $inventory->mocaco) }}" required>
                                @error('mocaco')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="n_carton">Número de Caja *</label>
                                <input type="text" class="form-control" id="n_carton" name="n_carton" 
                                       value="{{ old('n_carton', $inventory->n_carton) }}" required>
                                @error('n_carton')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="season_int">Temporada</label>
                                <input type="text" class="form-control" id="season_int" name="season_int" 
                                       value="{{ old('season_int', $inventory->season_int) }}">
                                @error('season_int')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="ubicacion">Ubicación</label>
                                <input type="text" class="form-control" id="ubicacion" name="ubicacion" 
                                       value="{{ old('ubicacion', $inventory->ubicacion) }}">
                                @error('ubicacion')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="n_id_operario">ID Operario</label>
                                <input type="text" class="form-control" id="n_id_operario" name="n_id_operario" 
                                       value="{{ old('n_id_operario', $inventory->n_id_operario) }}">
                                @error('n_id_operario')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="categoria_seleccionada">Categoría</label>
                                <input type="text" class="form-control" id="categoria_seleccionada" name="categoria_seleccionada" 
                                       value="{{ old('categoria_seleccionada', $inventory->categoria_seleccionada) }}">
                                @error('categoria_seleccionada')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="famillie_usuario">Familia</label>
                                <input type="text" class="form-control" id="famillie_usuario" name="famillie_usuario" 
                                       value="{{ old('famillie_usuario', $inventory->famillie_usuario) }}">
                                @error('famillie_usuario')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="cadena">Cadena</label>
                                <input type="text" class="form-control" id="cadena" name="cadena" 
                                       value="{{ old('cadena', $inventory->cadena) }}">
                                @error('cadena')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="precio_pvp_maximo_temporada">Precio PVP Máximo</label>
                                <input type="number" step="0.01" class="form-control" id="precio_pvp_maximo_temporada" 
                                       name="precio_pvp_maximo_temporada" value="{{ old('precio_pvp_maximo_temporada', $inventory->precio_pvp_maximo_temporada) }}">
                                @error('precio_pvp_maximo_temporada')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="notes">Notas</label>
                        <textarea class="form-control" id="notes" name="notes" rows="3">{{ old('notes', $inventory->notes) }}</textarea>
                        @error('notes')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label for="detail_usuario">Detalle Usuario</label>
                        <textarea class="form-control" id="detail_usuario" name="detail_usuario" rows="2">{{ old('detail_usuario', $inventory->detail_usuario) }}</textarea>
                        @error('detail_usuario')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="d-flex justify-content-end gap-2">
                        <a href="{{ route('inventory.index') }}" class="btn btn-secondary">
                            <i class="fas fa-times"></i> Cancelar
                        </a>
                        <button type="submit" class="btn">
                            <i class="fas fa-save"></i> Actualizar Item
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5><i class="fas fa-info-circle"></i> Información del Item</h5>
            </div>
            <div class="card-body">
                <p><strong>ID:</strong> {{ $inventory->id }}</p>
                <p><strong>Creado:</strong> {{ $inventory->created_at->format('d/m/Y H:i') }}</p>
                <p><strong>Actualizado:</strong> {{ $inventory->updated_at->format('d/m/Y H:i') }}</p>
                @if($inventory->fecha_escaneo)
                    <p><strong>Fecha Escaneo:</strong> {{ $inventory->fecha_escaneo->format('d/m/Y H:i') }}</p>
                @endif
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h5><i class="fas fa-trash"></i> Eliminar Item</h5>
            </div>
            <div class="card-body">
                <p class="text-muted">Esta acción no se puede deshacer.</p>
                <form action="{{ route('inventory.destroy', $inventory) }}" method="POST" 
                      onsubmit="return confirm('¿Está seguro de eliminar este item?')">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">
                        <i class="fas fa-trash"></i> Eliminar Item
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
// Auto-focus en el primer campo
document.addEventListener('DOMContentLoaded', function() {
    document.getElementById('full_barcode').focus();
});
</script>
@endpush

@push('styles')
<style>
.form-control {
    border: 1px solid var(--sap-border-color);
    border-radius: 4px;
    padding: 10px;
    font-size: 0.9em;
    transition: border-color 0.2s, box-shadow 0.2s;
}

.form-control:focus {
    border-color: var(--sap-blue-light);
    outline: none;
    box-shadow: 0 0 0 2px rgba(52, 152, 219, 0.2);
}

.text-danger {
    font-size: 0.8em;
    margin-top: 5px;
}

.gap-2 {
    gap: 10px;
}

.btn-danger {
    background-color: #dc3545;
    color: white;
    border: none;
}

.btn-danger:hover {
    background-color: #c82333;
}
</style>
@endpush

