@extends('layouts.app')

@section('title', 'Detalle del Item de Inventario')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-eye"></i> Detalle del Item de Inventario</h2>
    <div class="d-flex gap-2">
        @can('inventory.update')
        <a href="{{ route('inventory.edit', $inventory) }}" class="btn">
            <i class="fas fa-edit"></i> Editar
        </a>
        @endcan
        <a href="{{ route('inventory.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Volver
        </a>
    </div>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5><i class="fas fa-info-circle"></i> Información Principal</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="info-group">
                            <label>Código de Barras</label>
                            <p><code>{{ $inventory->full_barcode }}</code></p>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="info-group">
                            <label>MOCACO</label>
                            <p>{{ $inventory->mocaco }}</p>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="info-group">
                            <label>Número de Caja</label>
                            <p>{{ $inventory->n_carton }}</p>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="info-group">
                            <label>Temporada</label>
                            <p>{{ $inventory->season_int ?? '-' }}</p>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="info-group">
                            <label>Ubicación</label>
                            <p>{{ $inventory->ubicacion ?? '-' }}</p>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="info-group">
                            <label>ID Operario</label>
                            <p>{{ $inventory->n_id_operario ?? '-' }}</p>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="info-group">
                            <label>Status</label>
                            <p>
                                @if($inventory->status === 'reservado' && $inventory->order)
                                    <strong>Reservado</strong> & {{ $inventory->order->client->client_name ?? 'N/A' }} & Pedido #{{ $inventory->order->id ?? 'N/A' }}
                                @else
                                    {{ ucfirst($inventory->status ?? 'disponible') }}
                                @endif
                            </p>
                        </div>
                    </div>
                    @if($inventory->order)
                    <div class="col-md-6">
                        <div class="info-group">
                            <label>Pedido Asociado</label>
                            <p>
                                <a href="{{ route('orders.show', $inventory->order) }}">
                                    Pedido #{{ $inventory->order->id }}
                                </a> - Cliente: {{ $inventory->order->client->client_name ?? 'N/A' }}
                            </p>
                        </div>
                    </div>
                    @endif
                </div>

                @if($inventory->notes)
                <div class="info-group">
                    <label>Notas</label>
                    <p>{{ $inventory->notes }}</p>
                </div>
                @endif

                @if($inventory->detail_usuario)
                <div class="info-group">
                    <label>Detalle Usuario</label>
                    <p>{{ $inventory->detail_usuario }}</p>
                </div>
                @endif
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h5><i class="fas fa-tags"></i> Clasificación</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="info-group">
                            <label>Categoría</label>
                            <p>{{ $inventory->categoria_seleccionada ?? '-' }}</p>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="info-group">
                            <label>Familia</label>
                            <p>{{ $inventory->famillie_usuario ?? '-' }}</p>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="info-group">
                            <label>Sección</label>
                            <p>{{ $inventory->seccion ?? '-' }}</p>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="info-group">
                            <label>Cadena</label>
                            <p>{{ $inventory->cadena ?? '-' }}</p>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="info-group">
                            <label>Mercado Origen</label>
                            <p>{{ $inventory->mercado_origen_articulo ?? '-' }}</p>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="info-group">
                            <label>Campana</label>
                            <p>{{ $inventory->campana ?? '-' }}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h5><i class="fas fa-dollar-sign"></i> Información Comercial</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="info-group">
                            <label>Precio PVP Máximo</label>
                            <p>{{ $inventory->precio_pvp_maximo_temporada ? '$' . number_format($inventory->precio_pvp_maximo_temporada, 2) : '-' }}</p>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="info-group">
                            <label>Peso Unitario</label>
                            <p>{{ $inventory->peso_unitario ? $inventory->peso_unitario . ' kg' : '-' }}</p>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="info-group">
                            <label>Partida Arancelaria</label>
                            <p>{{ $inventory->partida_arancelaria ?? '-' }}</p>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="info-group">
                            <label>Grupo Arancelario</label>
                            <p>{{ $inventory->grupo_arancelario ?? '-' }}</p>
                        </div>
                    </div>
                </div>

                @if($inventory->composition)
                <div class="info-group">
                    <label>Composición</label>
                    <p>{{ $inventory->composition }}</p>
                </div>
                @endif
            </div>
        </div>
    </div>

    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5><i class="fas fa-clock"></i> Información Temporal</h5>
            </div>
            <div class="card-body">
                <div class="info-group">
                    <label>ID del Item</label>
                    <p><strong>{{ $inventory->id }}</strong></p>
                </div>
                
                <div class="info-group">
                    <label>Creado</label>
                    <p>{{ $inventory->created_at->format('d/m/Y H:i:s') }}</p>
                </div>
                
                <div class="info-group">
                    <label>Última Actualización</label>
                    <p>{{ $inventory->updated_at->format('d/m/Y H:i:s') }}</p>
                </div>
                
                @if($inventory->fecha_escaneo)
                <div class="info-group">
                    <label>Fecha de Escaneo</label>
                    <p>{{ $inventory->fecha_escaneo->format('d/m/Y H:i:s') }}</p>
                </div>
                @endif
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h5><i class="fas fa-cogs"></i> Acciones</h5>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <a href="{{ route('inventory.edit', $inventory) }}" class="btn">
                        <i class="fas fa-edit"></i> Editar Item
                    </a>
                    
                    <button type="button" class="btn btn-outline-primary" onclick="printLabel()">
                        <i class="fas fa-print"></i> Imprimir Etiqueta
                    </button>
                    
                    <button type="button" class="btn btn-outline-info" onclick="copyBarcode()">
                        <i class="fas fa-copy"></i> Copiar Código de Barras
                    </button>
                    
                    <form action="{{ route('inventory.destroy', $inventory) }}" method="POST" 
                          onsubmit="return confirm('¿Está seguro de eliminar este item?')">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger w-100">
                            <i class="fas fa-trash"></i> Eliminar Item
                        </button>
                    </form>
                </div>
            </div>
        </div>

        @if($inventory->article)
        <div class="card mt-3">
            <div class="card-header">
                <h5><i class="fas fa-link"></i> Artículo Relacionado</h5>
            </div>
            <div class="card-body">
                <div class="info-group">
                    <label>MOCACO del Artículo</label>
                    <p>{{ $inventory->article->mocaco }}</p>
                </div>
                
                @if($inventory->article->description)
                <div class="info-group">
                    <label>Descripción</label>
                    <p>{{ $inventory->article->description }}</p>
                </div>
                @endif
            </div>
        </div>
        @endif
    </div>
</div>
@endsection

@push('scripts')
<script>
function printLabel() {
    // Esta función se implementará cuando creemos el módulo de impresión
    alert('Funcionalidad de impresión próximamente disponible');
}

function copyBarcode() {
    const barcode = '{{ $inventory->full_barcode }}';
    navigator.clipboard.writeText(barcode).then(function() {
        alert('Código de barras copiado al portapapeles');
    }, function(err) {
        console.error('Error al copiar: ', err);
        // Fallback para navegadores que no soportan clipboard API
        const textArea = document.createElement('textarea');
        textArea.value = barcode;
        document.body.appendChild(textArea);
        textArea.select();
        document.execCommand('copy');
        document.body.removeChild(textArea);
        alert('Código de barras copiado al portapapeles');
    });
}
</script>
@endpush

@push('styles')
<style>
.info-group {
    margin-bottom: 20px;
}

.info-group label {
    font-weight: 600;
    color: var(--sap-text-medium);
    font-size: 0.9em;
    margin-bottom: 5px;
    display: block;
}

.info-group p {
    margin: 0;
    padding: 8px 12px;
    background-color: #f8f9fa;
    border-radius: 4px;
    border-left: 3px solid var(--sap-blue-light);
    font-size: 0.95em;
}

code {
    font-family: 'Courier New', monospace;
    background-color: #e9ecef;
    padding: 2px 6px;
    border-radius: 3px;
    font-size: 0.9em;
    color: #495057;
}

.gap-2 {
    gap: 10px;
}

.d-grid {
    display: grid;
}

.gap-2 {
    gap: 10px;
}

.btn-outline-primary {
    background-color: transparent;
    color: var(--sap-blue-light);
    border: 1px solid var(--sap-blue-light);
}

.btn-outline-primary:hover {
    background-color: var(--sap-blue-light);
    color: white;
}

.btn-outline-info {
    background-color: transparent;
    color: #17a2b8;
    border: 1px solid #17a2b8;
}

.btn-outline-info:hover {
    background-color: #17a2b8;
    color: white;
}

.w-100 {
    width: 100%;
}
</style>
@endpush

