<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>@yield('title', __('app.html_title'))</title>

    <!-- CSS Libraries -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <style>
        /* Variables CSS para consistencia de colores */
        :root {
            --sap-blue-dark: #2C3E50;
            /* Base para sidebar */
            --sap-blue-medium: #34495E;
            /* Hover/activo en sidebar */
            --sap-blue-light: #3498DB;
            /* Destacado, botones */
            --sap-background-light: #F8F9FB;
            /* Fondo general */
            --sap-content-background: #FFFFFF;
            /* Fondo del área de contenido */
            --sap-text-dark: #333333;
            /* Texto principal */
            --sap-text-medium: #555555;
            /* Texto secundario/labels */
            --sap-border-color: #E0E0E0;
            /* Bordes suaves */
            --sap-shadow-light: rgba(0, 0, 0, 0.08);
            --sap-shadow-medium: rgba(0, 0, 0, 0.15);
        }

        body {
            font-family: 'Segoe UI', Arial, sans-serif;
            margin: 0;
            background-color: var(--sap-background-light);
            display: flex;
            min-height: 100vh;
            color: var(--sap-text-dark);
            font-size: 14px;
        }

        .sidebar {
            width: 250px;
            background-color: var(--sap-blue-dark);
            color: white;
            padding: 25px 0;
            box-shadow: 3px 0 15px var(--sap-shadow-medium);
            display: flex;
            flex-direction: column;
            align-items: center;
            position: sticky;
            top: 0;
            height: 100vh;
            overflow-y: auto;
        }

        .sidebar h2 {
            text-align: center;
            color: #ECF0F1;
            margin-bottom: 40px;
            font-size: 1.6em;
            padding: 0 15px;
            box-sizing: border-box;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            padding-bottom: 15px;
            width: calc(100% - 30px);
        }

        .sidebar ul {
            list-style: none;
            padding: 0;
            width: 100%;
        }

        .sidebar ul li {
            margin-bottom: 0;
        }

        .sidebar ul li a {
            display: flex;
            align-items: center;
            padding: 12px 25px;
            color: white;
            text-decoration: none;
            transition: background-color 0.2s ease, border-left 0.2s ease;
            font-size: 1.05em;
            position: relative;
        }

        .sidebar ul li a i {
            margin-right: 12px;
            font-size: 1.2em;
            color: rgba(255, 255, 255, 0.7);
        }

        .sidebar ul li a:hover {
            background-color: var(--sap-blue-medium);
            border-left: 5px solid var(--sap-blue-light);
            padding-left: 20px;
        }

        .sidebar ul li a.active {
            background-color: var(--sap-blue-light);
            font-weight: bold;
            border-left: 5px solid #FFD700;
            padding-left: 20px;
        }

        .sidebar ul li a.active i {
            color: white;
        }

        .content {
            flex-grow: 1;
            padding: 30px;
            background-color: var(--sap-content-background);
            margin: 20px;
            border-radius: 8px;
            box-shadow: 0 4px 15px var(--sap-shadow-light);
            overflow-y: auto;
        }

        .topbar {
            display: flex;
            justify-content: flex-end;
            align-items: center;
            margin-bottom: 15px;
        }

        .language-btn {
            background-color: #ffffff !important;
            color: var(--sap-text-dark) !important;
            border: 1px solid var(--sap-border-color);
            border-radius: 20px;
            padding: 6px 14px;
            font-size: 0.9em;
            display: flex;
            align-items: center;
            gap: 8px;
            min-width: auto;
            margin: 0;
        }

        .language-btn:hover {
            background-color: #f5f5f5 !important;
            color: var(--sap-text-dark) !important;
        }

        .language-flag {
            font-size: 1.1em;
            line-height: 1;
        }

        .language-selector .dropdown-menu {
            min-width: 220px;
        }

        .language-selector .dropdown-item {
            display: flex;
            align-items: center;
            justify-content: space-between;
            gap: 8px;
        }

        .language-selector .dropdown-item.active {
            background-color: var(--sap-blue-light);
            color: #fff;
        }

        /* Estilos generales de formularios y mensajes */
        .form-group {
            margin-bottom: 15px;
        }

        label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
            color: var(--sap-text-medium);
            font-size: 0.9em;
        }

        input[type="text"],
        input[type="number"],
        input[type="email"],
        textarea,
        select {
            width: calc(100% - 20px);
            padding: 10px;
            border: 1px solid var(--sap-border-color);
            border-radius: 4px;
            box-sizing: border-box;
            font-size: 0.9em;
            transition: border-color 0.2s, box-shadow 0.2s;
        }

        input[type="text"]:focus,
        input[type="number"]:focus,
        input[type="email"]:focus,
        textarea:focus,
        select:focus {
            border-color: var(--sap-blue-light);
            outline: none;
            box-shadow: 0 0 0 2px rgba(52, 152, 219, 0.2);
        }

        button,
        .btn {
            padding: 10px 20px;
            background-color: var(--sap-blue-light);
            color: white;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            margin-top: 10px;
            margin-right: 10px;
            font-size: 0.9em;
            transition: background-color 0.2s ease, transform 0.1s ease;
            min-width: 100px;
            text-decoration: none;
            display: inline-block;
        }

        button:hover,
        .btn:hover {
            background-color: #2980b9;
            transform: translateY(-1px);
            color: white;
        }

        button:active,
        .btn:active {
            transform: translateY(0);
        }

        .btn-success {
            background-color: #28a745;
        }

        .btn-success:hover {
            background-color: #218838;
        }

        .btn-danger {
            background-color: #dc3545;
        }

        .btn-danger:hover {
            background-color: #c82333;
        }

        .btn-secondary {
            background-color: #6c757d;
        }

        .btn-secondary:hover {
            background-color: #5a6268;
        }

        button:disabled {
            background-color: #cccccc;
            cursor: not-allowed;
            opacity: 0.7;
        }

        .message {
            padding: 12px;
            margin-bottom: 15px;
            border-radius: 4px;
            font-weight: bold;
            display: block;
            text-align: center;
            font-size: 0.9em;
        }

        .message.success {
            background-color: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }

        .message.error {
            background-color: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }

        .message.info {
            background-color: #d1ecf1;
            color: #0c5460;
            border: 1px solid #bee5eb;
        }

        /* Tabla de datos */
        .data-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
            font-size: 13px;
            box-shadow: 0 1px 5px var(--sap-shadow-light);
            border-radius: 6px;
            overflow: hidden;
        }

        .data-table th,
        .data-table td {
            border: 1px solid #DFE3E8;
            padding: 8px 12px;
            text-align: left;
            vertical-align: middle;
        }

        .data-table th {
            background-color: #F7F9FC;
            color: #555;
            font-weight: 600;
            position: sticky;
            top: 0;
            z-index: 2;
            cursor: pointer;
            padding-right: 25px;
            user-select: none;
            white-space: nowrap;
            transition: background-color 0.2s ease;
        }

        .data-table th:hover {
            background-color: #E6EEF5;
        }

        .data-table tbody tr:nth-child(even) {
            background-color: #FCFDFF;
        }

        .data-table tbody tr:hover {
            background-color: #EBF2F9;
        }

        /* Paginación */
        .pagination {
            display: flex;
            justify-content: center;
            align-items: center;
            margin-top: 20px;
            gap: 5px;
        }

        .pagination a,
        .pagination span {
            padding: 8px 12px;
            border: 1px solid var(--sap-border-color);
            color: var(--sap-blue-light);
            text-decoration: none;
            border-radius: 4px;
            transition: all 0.2s ease;
        }

        .pagination a:hover {
            background-color: #EBF2F9;
        }

        .pagination .current {
            background-color: var(--sap-blue-light);
            color: white;
            border-color: var(--sap-blue-light);
        }

        /* Responsive */
        @media (max-width: 768px) {
            body {
                flex-direction: column;
            }

            .sidebar {
                width: 100%;
                height: auto;
                position: relative;
                box-shadow: 0 3px 10px rgba(0, 0, 0, 0.1);
            }

            .sidebar ul {
                display: flex;
                flex-wrap: wrap;
                justify-content: center;
            }

            .sidebar ul li {
                width: auto;
                margin: 5px;
            }

            .sidebar ul li a {
                padding: 10px 15px;
                border-left: none;
                border-bottom: 3px solid transparent;
            }

            .sidebar ul li a:hover,
            .sidebar ul li a.active {
                padding-left: 15px;
                border-left: none;
                border-bottom: 3px solid var(--sap-blue-light);
            }

            .sidebar ul li a.active {
                border-bottom: 3px solid #FFD700;
            }

            .content {
                margin: 10px;
                padding: 20px;
            }
        }
    </style>

    @stack('styles')
</head>

<body>
    <div class="sidebar">
        <h2><i class="fas fa-warehouse"></i> {{ __('app.app_name') }}</h2>
        <ul>
            <li><a href="{{ route('dashboard') }}" class="{{ request()->routeIs('dashboard') ? 'active' : '' }}">
                    <i class="fas fa-tachometer-alt"></i> {{ __('app.sidebar.dashboard') }}
                </a></li>
            @can('inventory.view')
                <li><a href="{{ route('inventory.index') }}"
                        class="{{ request()->routeIs('inventory.index') || (request()->routeIs('inventory.*') && !request()->routeIs('article-review.*') && !request()->routeIs('inventory.boxes-without-location')) ? 'active' : '' }}">
                        <i class="fas fa-boxes"></i> {{ __('app.sidebar.inventory') }}
                    </a></li>
            @endcan
            @can('inventory.view')
                <li><a href="{{ route('article-review.index') }}"
                        class="{{ request()->routeIs('article-review.*') ? 'active' : '' }}">
                        <i class="fas fa-clipboard-check"></i> Revisión de Artículos
                    </a></li>
            @endcan
            @can('inventory.view')
                <li><a href="{{ route('inventory.boxes-without-location') }}"
                        class="{{ request()->routeIs('inventory.boxes-without-location') ? 'active' : '' }}">
                        <i class="fas fa-map-marker-slash"></i> Cajas Sin Ubicación
                    </a></li>
            @endcan
            @can('articles.view')
                <li><a href="{{ route('articles.index') }}"
                        class="{{ request()->routeIs('articles.*') ? 'active' : '' }}">
                        <i class="fas fa-tags"></i> {{ __('app.sidebar.articles') }}
                    </a></li>
            @endcan
            @can('clients.view')
                <li><a href="{{ route('clients.index') }}" class="{{ request()->routeIs('clients.*') ? 'active' : '' }}">
                        <i class="fas fa-handshake"></i> {{ __('app.sidebar.clients') }}
                    </a></li>
            @endcan
            @can('orders.view')
                <li><a href="{{ route('orders.index') }}" class="{{ request()->routeIs('orders.*') ? 'active' : '' }}">
                        <i class="fas fa-shopping-cart"></i> {{ __('app.sidebar.orders') }}
                    </a></li>
            @endcan

            @can('reservations.view')
                <li><a href="{{ route('reservations.index') }}"
                        class="{{ request()->routeIs('reservations.*') ? 'active' : '' }}">
                        <i class="fas fa-clipboard-list"></i> Reservas de Cajas
                    </a></li>
            @endcan

            @can('order-preparation.view')
                <li><a href="{{ route('order-preparation') }}"
                        class="{{ request()->routeIs('order-preparation.*') ? 'active' : '' }}">
                        <i class="fas fa-shopping-cart"></i> {{ __('app.sidebar.order_preparation') }}
                    </a></li>
            @endcan
            @can('relabeling.view')
                <li><a href="{{ route('relabeling.index') }}"
                        class="{{ request()->routeIs('relabeling.*') ? 'active' : '' }}">
                        <i class="fas fa-redo"></i> {{ __('app.sidebar.relabeling') }}
                    </a></li>
            @endcan
            @can('inventory.view')
                <li><a href="{{ route('container-entries.index') }}"
                        class="{{ request()->routeIs('container-entries.*') ? 'active' : '' }}">
                        <i class="fas fa-truck"></i> {{ __('app.sidebar.container_entries') }}
                    </a></li>
            @endcan
            @can('inventory.scan')
                <li><a href="{{ route('scanner') }}" class="{{ request()->routeIs('scanner') ? 'active' : '' }}">
                        <i class="fas fa-barcode"></i> {{ __('app.sidebar.scanner') }}
                    </a></li>
            @endcan
            @can('scanner-options.view')
                <li><a href="{{ route('scanner-options.index') }}"
                        class="{{ request()->routeIs('scanner-options.*') ? 'active' : '' }}">
                        <i class="fas fa-list"></i> Opciones Escáner
                    </a></li>
            @endcan
            @can('brands.view')
            <li><a href="{{ route('brands.index') }}"
                    class="{{ request()->routeIs('brands.*') ? 'active' : '' }}">
                    <i class="fas fa-tag"></i> Maestro de Marcas
                </a></li>
            @endcan
            @can('location.view')
                <li><a href="{{ route('location') }}" class="{{ request()->routeIs('location') ? 'active' : '' }}">
                        <i class="fas fa-map-marker-alt"></i> {{ __('app.sidebar.assign_location') }}
                    </a></li>
            @endcan
            @can('client-history.view')
                <li><a href="{{ route('client-history') }}"
                        class="{{ request()->routeIs('client-history') ? 'active' : '' }}">
                        <i class="fas fa-history"></i> {{ __('app.sidebar.client_history') }}
                    </a></li>
            @endcan
            @can('reports.productivity.view')
                <li><a href="{{ route('reports.productivity') }}"
                        class="{{ request()->routeIs('reports.productivity*') ? 'active' : '' }}">
                        <i class="fas fa-chart-bar"></i> {{ __('app.sidebar.productivity_reports') }}
                    </a></li>
            @endcan
            @can('reports.stock.view')
                <li><a href="{{ route('reports.stock-summary') }}"
                        class="{{ request()->routeIs('reports.stock-summary') ? 'active' : '' }}">
                        <i class="fas fa-boxes"></i> {{ __('app.sidebar.stock_summary') }}
                    </a></li>
            @endcan
            @if (Auth::check() && (Auth::user()->hasRole('client') || Auth::user()->client_id))
                <li><a href="{{ route('portal.index') }}"
                        class="{{ request()->routeIs('portal.*') ? 'active' : '' }}">
                        <i class="fas fa-user-circle"></i> {{ __('app.sidebar.client_portal') }}
                    </a></li>
            @endif
            @can('users.view')
                <li><a href="{{ route('users.index') }}" class="{{ request()->routeIs('users.*') ? 'active' : '' }}">
                        <i class="fas fa-users"></i> {{ __('app.sidebar.users') }}
                    </a></li>
            @endcan
            @role('admin')
                <li><a href="{{ route('roles.index') }}" class="{{ request()->routeIs('roles.*') ? 'active' : '' }}">
                        <i class="fas fa-user-tag"></i> {{ __('app.sidebar.roles') }}
                    </a></li>
            @endrole
            @auth
                <li><a href="{{ route('logout') }}"
                        onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                        <i class="fas fa-sign-out-alt"></i> {{ __('app.auth.logout') }}
                    </a></li>
            @endauth
            @role('admin')
                <li><a href="{{ route('config.index') }}" class="{{ request()->routeIs('config.*') ? 'active' : '' }}">
                        <i class="fas fa-cog"></i> {{ __('app.sidebar.config') }}
                    </a></li>
            @endrole
        </ul>
    </div>

    <div class="content">
        @php
            $currentLocale = app()->getLocale();
            $languageOptions = [
                'es' => ['flag' => '🇪🇸', 'label' => __('app.language.spanish')],
                'en' => ['flag' => '🇺🇸', 'label' => __('app.language.english')],
                'fr' => ['flag' => '🇫🇷', 'label' => __('app.language.french')],
            ];
        @endphp

        <div class="topbar">
            <div class="language-selector dropdown">
                <button class="language-btn dropdown-toggle" type="button" data-bs-toggle="dropdown"
                    aria-expanded="false">
                    <span class="language-flag">{{ $languageOptions[$currentLocale]['flag'] ?? '🌐' }}</span>
                    {{ $languageOptions[$currentLocale]['label'] ?? strtoupper($currentLocale) }}
                </button>
                <ul class="dropdown-menu dropdown-menu-end">
                    @foreach ($languageOptions as $locale => $option)
                        <li>
                            <form method="POST" action="{{ route('language.switch') }}">
                                @csrf
                                <input type="hidden" name="locale" value="{{ $locale }}">
                                <button type="submit"
                                    class="dropdown-item d-flex align-items-center justify-content-between {{ $locale === $currentLocale ? 'active' : '' }}">
                                    <span><span class="language-flag">{{ $option['flag'] }}</span>
                                        {{ $option['label'] }}</span>
                                    @if ($locale === $currentLocale)
                                        <i class="fas fa-check text-success ms-2"></i>
                                    @endif
                                </button>
                            </form>
                        </li>
                    @endforeach
                </ul>
            </div>
        </div>

        @if (session('success'))
            <div class="message success">
                <i class="fas fa-check-circle"></i> {{ session('success') }}
            </div>
        @endif

        @if (session('error'))
            <div class="message error">
                <i class="fas fa-exclamation-circle"></i> {{ session('error') }}
            </div>
        @endif

        @if ($errors->any())
            <div class="message error">
                <i class="fas fa-exclamation-triangle"></i>
                <ul style="margin: 0; padding-left: 20px;">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        @yield('content')
    </div>

    <!-- Logout Form -->
    @auth
        <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
            @csrf
        </form>
    @endauth

    <!-- JavaScript Libraries -->
    <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous">
    </script>

    <!-- CSRF Token for AJAX -->
    <script>
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
    </script>

    @stack('scripts')
</body>

</html>
