@extends('layouts.app')

@section('title', __('orders.edit.title', ['id' => $order->id]))

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-edit"></i> {{ __('orders.edit.title', ['id' => $order->id]) }}</h2>
    <a href="{{ route('orders.index') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> {{ __('orders.buttons.back') }}
    </a>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5><i class="fas fa-edit"></i> {{ __('orders.edit.form_title') }}</h5>
            </div>
            <div class="card-body">
                <form method="POST" action="{{ route('orders.update', $order) }}" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="client_id">{{ __('orders.edit.client_label') }}</label>
                                <select class="form-control" id="client_id" name="client_id" required>
                                    <option value="">{{ __('orders.edit.client_select') }}</option>
                                    @foreach($clients as $client)
                                    <option value="{{ $client->id }}"
                                        {{ (old('client_id', $order->client_id) == $client->id) ? 'selected' : '' }}>
                                        {{ $client->client_name }} ({{ $client->email ?? __('orders.edit.client_no_email') }})
                                    </option>
                                    @endforeach
                                </select>
                                @error('client_id')
                                <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="operario_id">{{ __('orders.edit.operator_label') }}</label>
                                <input type="text" class="form-control" id="operario_id" name="operario_id"
                                    value="{{ old('operario_id', $order->operario_id) }}">
                                @error('operario_id')
                                <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="status">{{ __('orders.edit.status_label') }}</label>
                                <select class="form-control" id="status" name="status">
                                    <option value="draft" {{ old('status', $order->status) == 'draft' ? 'selected' : '' }}>{{ __('orders.status.draft') }}</option>
                                    <option value="pending" {{ old('status', $order->status) == 'pending' ? 'selected' : '' }}>{{ __('orders.status.pending') }}</option>
                                    <option value="dispatched" {{ old('status', $order->status) == 'dispatched' ? 'selected' : '' }}>{{ __('orders.status.dispatched') }}</option>
                                    <option value="cancelled" {{ old('status', $order->status) == 'cancelled' ? 'selected' : '' }}>{{ __('orders.status.cancelled') }}</option>
                                </select>
                                @error('status')
                                <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="order_date">{{ __('orders.edit.order_date_label') }}</label>
                                <input type="datetime-local" class="form-control" id="order_date" name="order_date"
                                    value="{{ old('order_date', $order->order_date ? $order->order_date->format('Y-m-d\TH:i') : '') }}">
                                @error('order_date')
                                <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="notes">{{ __('orders.edit.notes_label') }}</label>
                        <textarea class="form-control" id="notes" name="notes" rows="3">{{ old('notes', $order->notes) }}</textarea>
                        @error('notes')
                        <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    @if(Auth::user()->hasRole('admin') || Auth::user()->hasRole('facturacion') || Auth::user()->can('orders.manage_invoices'))
                    <div class="card mb-3">
                        <div class="card-header bg-info text-white">
                            <h6 class="mb-0"><i class="fas fa-file-invoice"></i> {{ __('orders.edit.invoice_section') }}</h6>
                        </div>
                        <div class="card-body">
                            <div class="form-group">
                                <label for="factura_file">{{ __('orders.edit.invoice_file_label') }}</label>
                                <input type="file" class="form-control" id="factura_file" name="factura_file"
                                    accept=".pdf">
                                <small class="text-muted">{{ __('orders.edit.invoice_file_note') }}</small>
                                @error('factura_file')
                                <div class="text-danger">{{ $message }}</div>
                                @enderror
                                @if($order->url_pdf_factura && !filter_var($order->url_pdf_factura, FILTER_VALIDATE_URL))
                                <div class="mt-2">
                                    <small class="text-success">
                                        <i class="fas fa-check-circle"></i> {{ __('orders.edit.invoice_current') }} {{ basename($order->url_pdf_factura) }}
                                    </small>
                                </div>
                                @endif
                            </div>

                            <div class="form-group mt-3">
                                <label for="url_pdf_factura">{{ __('orders.edit.invoice_url_label') }}</label>
                                <input type="url" class="form-control" id="url_pdf_factura" name="url_pdf_factura"
                                    value="{{ old('url_pdf_factura', filter_var($order->url_pdf_factura, FILTER_VALIDATE_URL) ? $order->url_pdf_factura : '') }}"
                                    placeholder="{{ __('orders.edit.invoice_url_placeholder') }}">
                                <small class="text-muted">{{ __('orders.edit.invoice_url_note') }}</small>
                                @error('url_pdf_factura')
                                <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>
                    @endif

                    <div class="d-flex justify-content-end gap-2">
                        <a href="{{ route('orders.index') }}" class="btn btn-secondary">
                            <i class="fas fa-times"></i> {{ __('orders.buttons.cancel') }}
                        </a>
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> {{ __('orders.buttons.update') }}
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5><i class="fas fa-info-circle"></i> {{ __('orders.edit.info_title') }}</h5>
            </div>
            <div class="card-body">
                <div class="mb-3">
                    <strong>{{ __('orders.show.order_id') }}:</strong><br>
                    <span class="text-muted">#{{ $order->id }}</span>
                </div>

                <div class="mb-3">
                    <strong>{{ __('orders.show.client') }}:</strong><br>
                    <span class="text-muted">{{ $order->client->client_name ?? 'N/A' }}</span>
                </div>

                <div class="mb-3">
                    <strong>{{ __('orders.edit.current_status') }}:</strong><br>
                    @php
                    $statusTranslations = [
                    'draft' => __('orders.status.draft'),
                    'reserved' => __('orders.status.reserved'),
                    'pending' => __('orders.status.pending'),
                    'dispatched' => __('orders.status.dispatched'),
                    'cancelled' => __('orders.status.cancelled'),
                    ];
                    $statusText = $statusTranslations[$order->status] ?? $order->status;
                    @endphp
                    @switch($order->status)
                    @case('draft')
                    <span class="badge bg-secondary">{{ $statusText }}</span>
                    @break
                    @case('pending')
                    <span class="badge bg-warning">{{ $statusText }}</span>
                    @break
                    @case('dispatched')
                    <span class="badge bg-success">{{ $statusText }}</span>
                    @break
                    @case('cancelled')
                    <span class="badge bg-danger">{{ $statusText }}</span>
                    @break
                    @default
                    <span class="badge bg-secondary">{{ $statusText }}</span>
                    @endswitch
                </div>

                <div class="mb-3">
                    <strong>{{ __('orders.edit.creation_date') }}:</strong><br>
                    <span class="text-muted">{{ $order->created_at->format('d/m/Y H:i') }}</span>
                </div>

                @if($order->dispatched_date)
                <div class="mb-3">
                    <strong>{{ __('orders.show.dispatch_date') }}:</strong><br>
                    <span class="text-muted">{{ $order->dispatched_date->format('d/m/Y H:i') }}</span>
                </div>
                @endif

                <div class="mb-3">
                    <strong>{{ __('orders.show.operator') }}:</strong><br>
                    <span class="text-muted">{{ $order->operario_id ?? 'N/A' }}</span>
                </div>

                @if($order->notes)
                <div class="mb-3">
                    <strong>{{ __('orders.show.notes') }}:</strong><br>
                    <span class="text-muted">{{ $order->notes }}</span>
                </div>
                @endif
            </div>
        </div>

        @if($order->orderItems && $order->orderItems->count() > 0)
        <div class="card mt-3">
            <div class="card-header">
                <h5><i class="fas fa-boxes"></i> {{ __('orders.edit.items_title') }}</h5>
            </div>
            <div class="card-body">
                <div class="mb-2">
                    <strong>{{ __('orders.edit.total_items') }}:</strong> {{ $order->orderItems->count() }}
                </div>

                <div class="mb-2">
                    <strong>{{ __('orders.edit.unique_boxes') }}:</strong> {{ $order->orderItems->pluck('n_carton')->unique()->count() }}
                </div>

                <div class="alert alert-info">
                    <i class="fas fa-info-circle"></i>
                    <small>{{ __('orders.edit.items_note') }}</small>
                </div>
            </div>
        </div>
        @endif
    </div>
</div>
@endsection

@push('styles')
<style>
    .form-control {
        border: 1px solid var(--sap-border-color);
        border-radius: 4px;
        padding: 10px;
        font-size: 0.9em;
        transition: border-color 0.2s, box-shadow 0.2s;
    }

    .form-control:focus {
        border-color: var(--sap-blue-light);
        outline: none;
        box-shadow: 0 0 0 2px rgba(52, 152, 219, 0.2);
    }

    .gap-2 {
        gap: 10px;
    }

    .badge {
        padding: 4px 8px;
        font-size: 0.75em;
        font-weight: 500;
        border-radius: 4px;
    }

    .bg-secondary {
        background-color: #6c757d !important;
    }

    .bg-warning {
        background-color: #ffc107 !important;
        color: #000 !important;
    }

    .bg-success {
        background-color: #28a745 !important;
    }

    .bg-danger {
        background-color: #dc3545 !important;
    }
</style>
@endpush