@extends('layouts.app')

@section('title', __('orders.title'))

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-shopping-cart"></i> {{ __('orders.title') }}</h2>
    <div class="d-flex gap-2">
        @can('orders.view')
        <a href="{{ route('orders.export') }}?{{ request()->getQueryString() }}" class="btn btn-secondary">
            <i class="fas fa-file-excel"></i> {{ __('orders.buttons.export_excel') }}
        </a>
        @endcan
        @can('orders.create')
        <a href="{{ route('orders.create') }}" class="btn">
            <i class="fas fa-plus"></i> {{ __('orders.buttons.new_order') }}
        </a>
        @endcan
    </div>
</div>

@if(session('error'))
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <i class="fas fa-exclamation-circle"></i> {{ session('error') }}
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
@endif

@if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="fas fa-check-circle"></i> {{ session('success') }}
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
@endif

@if(session('import_summary'))
    @php $summary = session('import_summary'); @endphp
    <div class="alert alert-info">
        <strong>{{ __('orders.import.summary_title') }}</strong>
        {{ $summary['reserved_boxes'] }} {{ __('orders.import.reserved_boxes') }} ({{ $summary['reserved_units'] }} {{ __('orders.import.reserved_units') }}) {{ __('orders.import.reserved') }}.
        {{ __('orders.import.orders_created') }}: {{ $summary['orders_created'] }}, {{ __('orders.import.orders_used') }}: {{ $summary['orders_used'] }}.
        {{ __('orders.import.processed_rows') }}: {{ $summary['processed_rows'] }}, {{ __('orders.import.skipped_rows') }}: {{ $summary['skipped_rows'] }}.
        @if(!empty($summary['errors']))
            <details class="mt-2">
                <summary>{{ __('orders.import.view_details') }} ({{ count($summary['errors']) }} {{ __('orders.import.errors') }})</summary>
                <ul class="mb-0">
                    @foreach($summary['errors'] as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </details>
        @endif
    </div>
@endif
<!-- Filtros -->
<div class="card mb-4">
    <div class="card-header">
        <h5><i class="fas fa-filter"></i> {{ __('orders.filters.title') }}</h5>
    </div>
    <div class="card-body">
        <form method="GET" action="{{ route('orders.index') }}" class="row g-3">
            <div class="col-md-3">
                <label for="search" class="form-label">{{ __('orders.filters.search') }}</label>
                <input type="text" class="form-control" id="search" name="search"
                       value="{{ request('search') }}" placeholder="{{ __('orders.filters.search_placeholder') }}">
            </div>
            <div class="col-md-3">
                <label for="status" class="form-label">{{ __('orders.filters.status') }}</label>
                <select class="form-control" id="status" name="status">
                    <option value="">{{ __('orders.filters.status_all') }}</option>
                    <option value="draft" {{ request('status') === 'draft' ? 'selected' : '' }}>{{ __('orders.status.draft') }}</option>
                    <option value="reserved" {{ request('status') === 'reserved' ? 'selected' : '' }}>{{ __('orders.status.reserved') }}</option>
                    <option value="pending" {{ request('status') === 'pending' ? 'selected' : '' }}>{{ __('orders.status.pending') }}</option>
                    <option value="dispatched" {{ request('status') === 'dispatched' ? 'selected' : '' }}>{{ __('orders.status.dispatched') }}</option>
                    <option value="cancelled" {{ request('status') === 'cancelled' ? 'selected' : '' }}>{{ __('orders.status.cancelled') }}</option>
                </select>
            </div>
            <div class="col-md-3">
                <label for="client_id" class="form-label">{{ __('orders.filters.client') }}</label>
                <select class="form-control" id="client_id" name="client_id">
                    <option value="">{{ __('orders.filters.client_all') }}</option>
                    @foreach($clients as $client)
                        <option value="{{ $client->id }}" {{ request('client_id') == $client->id ? 'selected' : '' }}>
                            {{ $client->client_name }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-3">
                <label class="form-label">&nbsp;</label>
                <div class="d-flex gap-2">
                    <button type="submit" class="btn">
                        <i class="fas fa-search"></i> {{ __('orders.filters.apply') }}
                    </button>
                    <a href="{{ route('orders.index') }}" class="btn btn-secondary">
                        <i class="fas fa-times"></i> {{ __('orders.filters.clear') }}
                    </a>
                </div>
            </div>
        </form>
    </div>
</div>

@can('orders.create')
<div class="card mb-4">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5><i class="fas fa-file-upload"></i> {{ __('orders.import.title') }}</h5>
        <div class="d-flex gap-2 align-items-center">
            <small class="text-muted">{{ __('orders.import.description') }}</small>
            <a href="{{ route('orders.reservations-template') }}" class="btn btn-outline-secondary btn-sm">
                <i class="fas fa-download"></i> {{ __('orders.import.download_template') }}
            </a>
        </div>
    </div>
    <div class="card-body">
        <form action="{{ route('orders.import-reservations') }}" method="POST" enctype="multipart/form-data" class="row g-3 align-items-end">
            @csrf
            <div class="col-md-6">
                <label for="reservations_file" class="form-label">{{ __('orders.import.file_label') }}</label>
                <input type="file" class="form-control" id="reservations_file" name="reservations_file" accept=".xlsx,.xls,.csv" required>
            </div>
            <div class="col-md-12">
                <button type="submit" class="btn btn-success">
                    <i class="fas fa-upload"></i> {{ __('orders.import.process') }}
                </button>
            </div>
        </form>
    </div>
</div>
@endcan

<!-- Tabla de Pedidos -->
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5><i class="fas fa-list"></i> {{ __('orders.title') }}</h5>
        <span class="badge bg-primary">{{ $orders->total() }} {{ __('orders.table.total_orders') }}</span>
    </div>
    <div class="card-body p-0">
        @if($orders->count() > 0)
            <div class="table-responsive">
                <table class="data-table">
                    <thead>
                        <tr>
                            <th>{{ __('orders.table.id') }}</th>
                            <th>{{ __('orders.table.client') }}</th>
                            <th>{{ __('orders.table.status') }}</th>
                            <th>{{ __('orders.table.operator') }}</th>
                            <th>{{ __('orders.table.date') }}</th>
                            <th>{{ __('orders.table.actions') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($orders as $order)
                            <tr>
                                <td>{{ $order->id }}</td>
                                <td>{{ $order->client->client_name ?? 'N/A' }}</td>
                                <td>
                                    @php
                                        $statusClasses = [
                                            'dispatched' => 'success',
                                            'cancelled' => 'danger',
                                            'pending' => 'primary',
                                            'reserved' => 'info',
                                            'draft' => 'warning',
                                        ];
                                        $statusClass = $statusClasses[$order->status] ?? 'secondary';
                                        $statusTranslations = [
                                            'draft' => __('orders.status.draft'),
                                            'reserved' => __('orders.status.reserved'),
                                            'pending' => __('orders.status.pending'),
                                            'dispatched' => __('orders.status.dispatched'),
                                            'cancelled' => __('orders.status.cancelled'),
                                        ];
                                        $statusText = $statusTranslations[$order->status] ?? ucfirst($order->status);
                                    @endphp
                                    <span class="badge badge-{{ $statusClass }}">
                                        {{ $statusText }}
                                    </span>
                                </td>
                                <td>{{ $order->operario_id ?? '-' }}</td>
                                <td>{{ $order->created_at->format('d/m/Y H:i') }}</td>
                                <td>
                                    <div class="btn-group" role="group">
                                        @can('orders.view')
                                        <a href="{{ route('orders.show', $order) }}" class="btn btn-sm btn-outline-info" title="{{ __('orders.buttons.view') }}">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        @endcan
                                        @can('orders.update')
                                        <a href="{{ route('orders.edit', $order) }}" class="btn btn-sm btn-outline-warning" title="{{ __('orders.buttons.edit') }}">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        @endcan
                                        @can('orders.view')
                                        <a href="{{ route('orders.export-order', $order) }}" class="btn btn-sm btn-outline-success" title="{{ __('orders.buttons.download_excel') }}">
                                            <i class="fas fa-file-excel"></i>
                                        </a>
                                        @endcan
                                        @can('orders.delete')
                                        <form action="{{ route('orders.destroy', $order) }}" method="POST"
                                              class="d-inline" onsubmit="return confirm('¿Está seguro de que desea CANCELAR este pedido? El pedido no se eliminará, solo cambiará su estado a CANCELADO.')">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-outline-danger" title="Cancelar pedido">
                                                <i class="fas fa-ban"></i>
                                            </button>
                                        </form>
                                        @endcan
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            <!-- Paginación -->
            <div class="card-footer">
                {{ $orders->links() }}
            </div>
        @else
            <div class="text-center py-5">
                <i class="fas fa-shopping-cart fa-3x text-muted mb-3"></i>
                <h5 class="text-muted">{{ __('orders.messages.no_orders') }}</h5>
                <p class="text-muted">{{ __('orders.messages.no_orders_description') }}</p>
                <a href="{{ route('orders.create') }}" class="btn">
                    <i class="fas fa-plus"></i> {{ __('orders.buttons.create_first') }}
                </a>
            </div>
        @endif
    </div>
</div>
@endsection

@push('styles')
<style>
.btn-group {
    display: flex;
    gap: 5px;
}

.btn-sm {
    padding: 5px 10px;
    font-size: 0.8em;
    min-width: auto;
}

.btn-outline-info {
    background-color: transparent;
    color: #17a2b8;
    border: 1px solid #17a2b8;
}

.btn-outline-info:hover {
    background-color: #17a2b8;
    color: white;
}

.btn-outline-warning {
    background-color: transparent;
    color: #ffc107;
    border: 1px solid #ffc107;
}

.btn-outline-warning:hover {
    background-color: #ffc107;
    color: white;
}

.btn-outline-danger {
    background-color: transparent;
    color: #dc3545;
    border: 1px solid #dc3545;
}

.btn-outline-danger:hover {
    background-color: #dc3545;
    color: white;
}

.btn-outline-success {
    background-color: transparent;
    color: #28a745;
    border: 1px solid #28a745;
}

.btn-outline-success:hover {
    background-color: #28a745;
    color: white;
}

.badge {
    padding: 0.5em 0.75em;
    font-size: 0.75em;
    font-weight: 700;
    line-height: 1;
    text-align: center;
    white-space: nowrap;
    vertical-align: baseline;
    border-radius: 0.375rem;
}

.bg-primary {
    background-color: var(--sap-blue-light) !important;
}

.badge-success {
    background-color: #28a745;
    color: white;
}

.badge-warning {
    background-color: #ffc107;
    color: #212529;
}

.badge-danger {
    background-color: #dc3545;
    color: white;
}

.badge-primary {
    background-color: #007bff;
    color: white;
}

.badge-info {
    background-color: #17a2b8;
    color: white;
}

.badge-secondary {
    background-color: #6c757d;
    color: white;
}
</style>
@endpush
