@extends('layouts.app')

@section('title', __('orders.details'))

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-shopping-cart"></i> {{ __('orders.show.title', ['id' => $order->id]) }}</h2>
    <a href="{{ route('orders.index') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> {{ __('orders.buttons.back') }}
    </a>
</div>

@if(session('error'))
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <i class="fas fa-exclamation-circle"></i> {{ session('error') }}
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
@endif

@if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="fas fa-check-circle"></i> {{ session('success') }}
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
@endif

<div class="row">
    <!-- Información General del Pedido -->
    <div class="col-md-8">
        <div class="card mb-4">
            <div class="card-header">
                <h5><i class="fas fa-info-circle"></i> {{ __('orders.show.general_info') }}</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <p><strong>{{ __('orders.show.order_id') }}:</strong> {{ $order->id }}</p>
                        <p><strong>{{ __('orders.show.client') }}:</strong> {{ $order->client->client_name ?? 'N/A' }}</p>
                        <p><strong>{{ __('orders.show.email') }}:</strong> {{ $order->client->email ?? 'N/A' }}</p>
                        <p><strong>{{ __('orders.show.phone') }}:</strong> {{ $order->client->phone ?? 'N/A' }}</p>
                    </div>
                    <div class="col-md-6">
                        <p><strong>{{ __('orders.show.status') }}:</strong>
                            @php
                                $statusClasses = [
                                    'dispatched' => 'success',
                                    'cancelled' => 'danger',
                                    'pending' => 'primary',
                                    'reserved' => 'info',
                                    'draft' => 'warning',
                                ];
                                $statusClass = $statusClasses[$order->status] ?? 'secondary';
                                $statusTranslations = [
                                    'draft' => __('orders.status.draft'),
                                    'reserved' => __('orders.status.reserved'),
                                    'pending' => __('orders.status.pending'),
                                    'dispatched' => __('orders.status.dispatched'),
                                    'cancelled' => __('orders.status.cancelled'),
                                ];
                                $statusText = $statusTranslations[$order->status] ?? ucfirst($order->status);
                            @endphp
                            <span class="badge badge-{{ $statusClass }}">
                                {{ $statusText }}
                            </span>
                        </p>
                        <p><strong>{{ __('orders.show.operator') }}:</strong> {{ $order->operario_id ?? 'N/A' }}</p>
                        <p><strong>{{ __('orders.show.order_date') }}:</strong> {{ $order->created_at->format('d/m/Y H:i') }}</p>
                        <p><strong>{{ __('orders.show.dispatch_date') }}:</strong> {{ $order->dispatched_date ? $order->dispatched_date->format('d/m/Y H:i') : 'N/A' }}</p>
                    </div>
                </div>
                @if($order->notes)
                    <div class="mt-3">
                        <strong>{{ __('orders.show.notes') }}:</strong>
                        <p>{{ $order->notes }}</p>
                    </div>
                @endif
            </div>
        </div>

        <!-- Artículos del Pedido -->
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5><i class="fas fa-boxes"></i> {{ __('orders.show.items_count', ['count' => $order->orderItems->count()]) }}</h5>
            </div>
            <div class="card-body p-0">
                @if($order->orderItems->count() > 0)
                    <div class="table-responsive">
                        <table class="data-table">
                            <thead>
                                <tr>
                                    <th>{{ __('orders.show.barcode') }}</th>
                                    <th>{{ __('orders.show.mocaco') }}</th>
                                    <th>{{ __('orders.show.box_number') }}</th>
                                    <th>{{ __('orders.show.location') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($order->orderItems as $item)
                                    <tr>
                                        <td><code>{{ $item->full_barcode }}</code></td>
                                        <td>{{ $item->mocaco ?? 'N/A' }}</td>
                                        <td>{{ $item->n_carton ?? 'N/A' }}</td>
                                        <td>{{ $item->ubicacion ?? 'N/A' }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                @else
                    <div class="text-center py-5">
                        <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                        <p class="text-muted">{{ __('orders.show.no_items') }}</p>
                    </div>
                @endif
            </div>
        </div>
    </div>

    <!-- Panel de Acciones -->
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5><i class="fas fa-cog"></i> {{ __('orders.show.actions') }}</h5>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <a href="{{ route('orders.export-order', $order) }}" class="btn btn-info">
                        <i class="fas fa-file-excel"></i> {{ __('orders.show.download_order') }}
                    </a>

                    @if($order->url_pdf_factura)
                        <a href="{{ route('orders.download-invoice', $order) }}" class="btn btn-success" target="_blank">
                            <i class="fas fa-file-pdf"></i> {{ __('orders.buttons.download_invoice') }}
                        </a>
                    @else
                        <button type="button" class="btn btn-secondary" disabled>
                            <i class="fas fa-file-pdf"></i> {{ __('orders.buttons.invoice_not_available') }}
                        </button>
                    @endif

                    @if($order->status === 'draft')
                        @can('orders.update')
                        <a href="{{ route('orders.edit', $order) }}" class="btn">
                            <i class="fas fa-edit"></i> {{ __('orders.buttons.edit') }}
                        </a>
                        @endcan
                    @endif

                    @if($order->status !== 'dispatched' && $order->status !== 'cancelled')
                        @can('orders.delete')
                        <form action="{{ route('orders.destroy', $order) }}" method="POST" onsubmit="return confirm('¿Está seguro de que desea CANCELAR este pedido? El pedido no se eliminará, solo cambiará su estado a CANCELADO.')">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-danger w-100">
                                <i class="fas fa-ban"></i> Cancelar Pedido
                            </button>
                        </form>
                        @endcan
                    @endif
                </div>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h5><i class="fas fa-info-circle"></i> {{ __('orders.show.client_info') }}</h5>
            </div>
            <div class="card-body">
                <p><strong>{{ __('orders.show.client') }}:</strong> {{ $order->client->client_name ?? 'N/A' }}</p>
                <p><strong>{{ __('orders.show.email') }}:</strong> {{ $order->client->email ?? 'N/A' }}</p>
                <p><strong>{{ __('orders.show.phone') }}:</strong> {{ $order->client->phone ?? 'N/A' }}</p>
                <p><strong>{{ __('orders.show.address') }}:</strong> {{ $order->client->address ?? 'N/A' }}</p>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
.btn-group {
    display: flex;
    gap: 5px;
}

.btn-sm {
    padding: 5px 10px;
    font-size: 0.8em;
    min-width: auto;
}

.badge {
    padding: 0.5em 0.75em;
    font-size: 0.75em;
    font-weight: 700;
    line-height: 1;
    text-align: center;
    white-space: nowrap;
    vertical-align: baseline;
    border-radius: 0.375rem;
}

.badge-success {
    background-color: #28a745;
    color: white;
}

.badge-warning {
    background-color: #ffc107;
    color: #212529;
}

.badge-danger {
    background-color: #dc3545;
    color: white;
}

code {
    font-family: 'Courier New', monospace;
    background-color: #f8f9fa;
    padding: 2px 4px;
    border-radius: 3px;
    font-size: 0.9em;
}

.gap-2 {
    gap: 10px;
}

.d-grid {
    display: grid;
}

.w-100 {
    width: 100%;
}
</style>
@endpush

