@extends('layouts.app')

@section('title', __('portal.show.title', ['id' => $order->id]))

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-shopping-cart"></i> {{ __('portal.show.header', ['id' => $order->id]) }}</h2>
    <a href="{{ route('portal.index') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> {{ __('portal.common.back') }}
    </a>
</div>

@if(session('success'))
<div class="alert alert-success alert-dismissible fade show mb-4" role="alert">
    <i class="fas fa-check-circle"></i> {{ session('success') }}
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
</div>
@endif

@if(session('error'))
<div class="alert alert-danger alert-dismissible fade show mb-4" role="alert">
    <i class="fas fa-exclamation-circle"></i> {{ session('error') }}
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
</div>
@endif

<div class="row">
    <!-- Información del Pedido -->
    <div class="col-md-4">
        <div class="card mb-4">
            <div class="card-header">
                <h5><i class="fas fa-info-circle"></i> {{ __('portal.show.info_card') }}</h5>
            </div>
            <div class="card-body">
                <table class="table table-borderless">
                    <tr>
                        <th width="40%">{{ __('portal.show.fields.order_id') }}</th>
                        <td><strong>#{{ $order->id }}</strong></td>
                    </tr>
                    <tr>
                        <th>{{ __('portal.show.fields.status') }}</th>
                        <td>
                            @php
                                $statusKey = 'portal.statuses.' . $order->status;
                                $statusLabel = __($statusKey);
                                if ($statusLabel === $statusKey) {
                                    $statusLabel = ucfirst($order->status);
                                }
                                $statusClass = match($order->status) {
                                    'reservado' => 'bg-warning',
                                    'confirmed' => 'bg-info',
                                    'dispatched' => 'bg-success',
                                    default => 'bg-secondary',
                                };
                            @endphp
                            <span class="badge {{ $statusClass }}">{{ $statusLabel }}</span>
                        </td>
                    </tr>
                    <tr>
                        <th>{{ __('portal.show.fields.order_date') }}</th>
                        <td>{{ $order->order_date->format('d/m/Y H:i') }}</td>
                    </tr>
                    @if($order->dispatched_date)
                    <tr>
                        <th>{{ __('portal.show.fields.dispatch_date') }}</th>
                        <td>{{ $order->dispatched_date->format('d/m/Y H:i') }}</td>
                    </tr>
                    @endif
                    @if($order->notes)
                    <tr>
                        <th>{{ __('portal.show.fields.notes') }}</th>
                        <td>{{ $order->notes }}</td>
                    </tr>
                    @endif
                </table>
                
                <div class="mt-3 pt-3 border-top">
                    <a href="{{ route('portal.download-excel', $order) }}" class="btn btn-info w-100 mb-2">
                        <i class="fas fa-file-excel"></i> {{ __('portal.show.downloads.order_excel') }}
                    </a>
                    
                    @if($order->url_pdf_factura)
                    <a href="{{ route('portal.download-invoice', $order) }}" class="btn btn-success w-100" target="_blank">
                        <i class="fas fa-file-pdf"></i> {{ __('portal.show.downloads.invoice_pdf') }}
                    </a>
                @else
                    <p class="text-muted small mb-0 mt-2">
                        <i class="fas fa-info-circle"></i> {{ __('portal.show.downloads.invoice_pending') }}
                    </p>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Packing List Agrupado -->
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5><i class="fas fa-boxes"></i> {{ __('portal.show.packing.title') }}</h5>
            </div>
            <div class="card-body p-0">
                @if(count($packingList) > 0)
                    <div class="table-responsive">
                        <table class="data-table">
                            <thead>
                                <tr>
                                    <th>{{ __('portal.show.packing.headers.mocaco') }}</th>
                                    <th>{{ __('portal.show.packing.headers.family') }}</th>
                                    <th>{{ __('portal.show.packing.headers.section') }}</th>
                                    <th>{{ __('portal.show.packing.headers.campaign') }}</th>
                                    <th>{{ __('portal.show.packing.headers.units') }}</th>
                                    <th>{{ __('portal.show.packing.headers.boxes') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($packingList as $item)
                                    <tr>
                                        <td><code>{{ $item['mocaco'] }}</code></td>
                                        <td>{{ $item['familia'] }}</td>
                                        <td>{{ $item['seccion'] ?? '-' }}</td>
                                        <td>{{ $item['campana'] ?? '-' }}</td>
                                        <td><strong>{{ $item['unidades'] }}</strong></td>
                                        <td>
                                            @php
                                                $boxCount = count($item['cajas']);
                                                $boxList = implode(', ', array_slice($item['cajas'], 0, 5));
                                            @endphp
                                            <small class="text-muted">
                                                {{ __('portal.show.packing.boxes', ['count' => $boxCount, 'list' => $boxList]) }}
                                                @if($boxCount > 5)
                                                    {{ __('portal.show.packing.more', ['count' => $boxCount - 5]) }}
                                                @endif
                                            </small>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    
                    <div class="card-footer bg-light">
                        <div class="row text-center">
                            <div class="col-md-4">
                                <strong>{{ __('portal.show.packing.totals.items') }}</strong> {{ $order->orderItems->count() ?? 0 }}
                            </div>
                            <div class="col-md-4">
                                <strong>{{ __('portal.show.packing.totals.groups') }}</strong> {{ count($packingList) }}
                            </div>
                            <div class="col-md-4">
                                <strong>{{ __('portal.show.packing.totals.boxes') }}</strong> 
                                @php
                                    $allBoxes = [];
                                    foreach($packingList as $item) {
                                        $allBoxes = array_merge($allBoxes, $item['cajas']);
                                    }
                                    echo count(array_unique($allBoxes));
                                @endphp
                            </div>
                        </div>
                    </div>
                @else
                    <div class="text-center py-5">
                        <i class="fas fa-box-open fa-3x text-muted mb-3"></i>
                        <h5 class="text-muted">{{ __('portal.show.packing.empty') }}</h5>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>

@push('styles')
<style>
.data-table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 0;
    font-size: 13px;
    box-shadow: 0 1px 5px rgba(0,0,0,0.08);
    border-radius: 0;
    overflow: hidden;
}

.data-table th, .data-table td {
    border: 1px solid #DFE3E8;
    padding: 8px 12px;
    text-align: left;
    vertical-align: middle;
}

.data-table th {
    background-color: #F7F9FC;
    color: #555;
    font-weight: 600;
}

.data-table tbody tr:nth-child(even) {
    background-color: #FCFDFF;
}

.data-table tbody tr:hover {
    background-color: #EBF2F9;
}

.badge {
    padding: 4px 8px;
    font-size: 0.75em;
    font-weight: 500;
    border-radius: 4px;
}

.bg-warning { background-color: #ffc107 !important; color: #000 !important; }
.bg-info { background-color: #17a2b8 !important; }
.bg-success { background-color: #28a745 !important; }
.bg-secondary { background-color: #6c757d !important; }

code {
    font-family: 'Courier New', monospace;
    background-color: #f8f9fa;
    padding: 2px 4px;
    border-radius: 3px;
    font-size: 0.9em;
}
</style>
@endpush
@endsection

