@extends('layouts.app')

@section('title', __('roles.create'))

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-user-plus"></i> {{ __('roles.create_new') }}</h2>
    <a href="{{ route('roles.index') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> {{ __('roles.back') }}
    </a>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5><i class="fas fa-edit"></i> {{ __('roles.info.role_info') }}</h5>
            </div>
            <div class="card-body">
                <form method="POST" action="{{ route('roles.store') }}">
                    @csrf
                    
                    <div class="form-group">
                        <label for="name">{{ __('roles.fields.name') }} *</label>
                        <input type="text" class="form-control" id="name" name="name" 
                               value="{{ old('name') }}" required placeholder="{{ __('roles.fields.name_placeholder') }}">
                        @error('name')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                        <small class="text-muted">{{ __('roles.fields.name_hint') }}</small>
                    </div>

                    <div class="form-group">
                        <label for="permissions">{{ __('roles.fields.permissions') }} *</label>
                        <div style="max-height: 300px; overflow-y: auto; border: 1px solid #ddd; padding: 10px; border-radius: 4px;">
                            @foreach($permissions as $permission)
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="permissions[]" 
                                           value="{{ $permission->id }}" id="permission_{{ $permission->id }}"
                                           {{ in_array($permission->id, old('permissions', [])) ? 'checked' : '' }}>
                                    <label class="form-check-label" for="permission_{{ $permission->id }}">
                                        {{ $permission->name }}
                                    </label>
                                </div>
                            @endforeach
                        </div>
                        @error('permissions')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="d-flex justify-content-end gap-2">
                        <a href="{{ route('roles.index') }}" class="btn btn-secondary">
                            <i class="fas fa-times"></i> {{ __('roles.buttons.cancel') }}
                        </a>
                        <button type="submit" class="btn">
                            <i class="fas fa-save"></i> {{ __('roles.buttons.create') }}
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5><i class="fas fa-info-circle"></i> {{ __('roles.info.title') }}</h5>
            </div>
            <div class="card-body">
                <p class="text-muted">
                    <strong>{{ __('roles.info.name_note') }}</strong> {{ __('roles.info.name_description') }}
                </p>
                <p class="text-muted">
                    <strong>{{ __('roles.info.permissions_note') }}</strong> {{ __('roles.info.permissions_description') }}
                </p>
                <p class="text-muted">
                    <strong>{{ __('roles.info.example') }}</strong> {{ __('roles.info.example_text') }}
                </p>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h5><i class="fas fa-list"></i> {{ __('roles.categories.title') }}</h5>
            </div>
            <div class="card-body">
                <p><strong>{{ __('roles.categories.inventory') }}</strong> {{ __('roles.categories.inventory_perms') }}</p>
                <p><strong>{{ __('roles.categories.articles') }}</strong> {{ __('roles.categories.articles_perms') }}</p>
                <p><strong>{{ __('roles.categories.clients') }}</strong> {{ __('roles.categories.clients_perms') }}</p>
                <p><strong>{{ __('roles.categories.orders') }}</strong> {{ __('roles.categories.orders_perms') }}</p>
                <p><strong>{{ __('roles.categories.relabeling') }}</strong> {{ __('roles.categories.relabeling_perms') }}</p>
                <p><strong>{{ __('roles.categories.users') }}</strong> {{ __('roles.categories.users_perms') }}</p>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
.form-control {
    border: 1px solid var(--sap-border-color);
    border-radius: 4px;
    padding: 10px;
    font-size: 0.9em;
    transition: border-color 0.2s, box-shadow 0.2s;
}

.form-control:focus {
    border-color: var(--sap-blue-light);
    outline: none;
    box-shadow: 0 0 0 2px rgba(52, 152, 219, 0.2);
}

.form-check {
    margin-bottom: 8px;
}

.text-danger {
    font-size: 0.8em;
    margin-top: 5px;
}

.gap-2 {
    gap: 10px;
}
</style>
@endpush

