@extends('layouts.app')

@section('title', __('roles.title'))

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-user-tag"></i> {{ __('roles.title') }}</h2>
    <a href="{{ route('roles.create') }}" class="btn">
        <i class="fas fa-plus"></i> {{ __('roles.new') }}
    </a>
</div>

<!-- Tabla de Roles -->
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5><i class="fas fa-list"></i> {{ __('roles.table.title') }}</h5>
        <span class="badge bg-primary">{{ $roles->total() }} {{ __('roles.table.total') }}</span>
    </div>
    <div class="card-body p-0">
        @if($roles->count() > 0)
            <div class="table-responsive">
                <table class="data-table">
                    <thead>
                        <tr>
                            <th>{{ __('roles.table.id') }}</th>
                            <th>{{ __('roles.table.name') }}</th>
                            <th>{{ __('roles.table.permissions') }}</th>
                            <th>{{ __('roles.table.users') }}</th>
                            <th>{{ __('roles.table.actions') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($roles as $role)
                            <tr>
                                <td>{{ $role->id }}</td>
                                <td><strong>{{ ucfirst($role->name) }}</strong></td>
                                <td>
                                    @if($role->permissions->count() > 0)
                                        <span class="badge badge-info">{{ $role->permissions->count() }} {{ __('roles.table.permissions_count') }}</span>
                                    @else
                                        <span class="badge badge-warning">{{ __('roles.table.no_permissions') }}</span>
                                    @endif
                                </td>
                                <td>{{ $role->users->count() }} {{ __('roles.table.users_count') }}</td>
                                <td>
                                    <div class="btn-group" role="group">
                                        <a href="{{ route('roles.show', $role) }}" class="btn btn-sm btn-outline-info">
                                            <i class="fas fa-eye"></i> {{ __('roles.buttons.view_permissions') }}
                                        </a>
                                        <a href="{{ route('roles.edit', $role) }}" class="btn btn-sm btn-outline-warning">
                                            <i class="fas fa-edit"></i> {{ __('roles.buttons.edit') }}
                                        </a>
                                        @if(!in_array($role->name, ['admin', 'manager', 'operator', 'scanner', 'viewer']))
                                            <form action="{{ route('roles.destroy', $role) }}" method="POST" 
                                                  class="d-inline" onsubmit="return confirm('{{ __('roles.messages.delete_confirm') }}')">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-outline-danger">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        @endif
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            
            <!-- Paginación -->
            <div class="card-footer">
                {{ $roles->links() }}
            </div>
        @else
            <div class="text-center py-5">
                <i class="fas fa-user-tag fa-3x text-muted mb-3"></i>
                <h5 class="text-muted">{{ __('roles.table.no_roles') }}</h5>
                <p class="text-muted">{{ __('roles.table.no_roles_message') }}</p>
                <a href="{{ route('roles.create') }}" class="btn">
                    <i class="fas fa-plus"></i> {{ __('roles.table.create_first') }}
                </a>
            </div>
        @endif
    </div>
</div>
@endsection

@push('styles')
<style>
.btn-group {
    display: flex;
    gap: 5px;
}

.btn-sm {
    padding: 5px 10px;
    font-size: 0.8em;
    min-width: auto;
}

.btn-outline-info {
    background-color: transparent;
    color: #17a2b8;
    border: 1px solid #17a2b8;
}

.btn-outline-info:hover {
    background-color: #17a2b8;
    color: white;
}

.btn-outline-warning {
    background-color: transparent;
    color: #ffc107;
    border: 1px solid #ffc107;
}

.btn-outline-warning:hover {
    background-color: #ffc107;
    color: white;
}

.btn-outline-danger {
    background-color: transparent;
    color: #dc3545;
    border: 1px solid #dc3545;
}

.btn-outline-danger:hover {
    background-color: #dc3545;
    color: white;
}

.badge {
    padding: 4px 8px;
    font-size: 0.75em;
    font-weight: 500;
    border-radius: 4px;
}

.bg-primary {
    background-color: var(--sap-blue-light) !important;
}

.badge-info {
    background-color: #17a2b8;
    color: white;
}

.badge-warning {
    background-color: #ffc107;
    color: #212529;
}
</style>
@endpush

