@extends('layouts.app')

@section('title', 'Opciones del Escáner')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-list"></i> Opciones del Escáner</h2>
    <a href="{{ route('scanner-options.create') }}" class="btn">
        <i class="fas fa-plus"></i> Nueva Opción
    </a>
</div>

<!-- Filtros -->
<div class="card mb-4">
    <div class="card-header">
        <h5><i class="fas fa-filter"></i> Filtros</h5>
    </div>
    <div class="card-body">
        <form method="GET" action="{{ route('scanner-options.index') }}" class="row g-3">
            <div class="col-md-4">
                <label for="type" class="form-label">Tipo</label>
                <select class="form-control" id="type" name="type" onchange="this.form.submit()">
                    <option value="">Todos los tipos</option>
                    @foreach($types as $type)
                    <option value="{{ $type }}" {{ request('type') === $type ? 'selected' : '' }}>
                        {{ ucfirst($type) }}
                    </option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-4">
                <label class="form-label">&nbsp;</label>
                <div class="d-flex gap-2">
                    <a href="{{ route('scanner-options.index') }}" class="btn btn-secondary">
                        <i class="fas fa-times"></i> Limpiar
                    </a>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Tabla -->
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5><i class="fas fa-table"></i> Listado de Opciones</h5>
        <span class="badge bg-primary">{{ $options->total() }} Total</span>
    </div>
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-striped mb-0">
                <thead>
                    <tr>
                        <th>Tipo</th>
                        <th>Valor (Interno)</th>
                        <th>Etiqueta (Visible)</th>
                        <th>Estado</th>
                        <th>Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($options as $option)
                    <tr>
                        <td><span class="badge bg-secondary">{{ ucfirst($option->type) }}</span></td>
                        <td>{{ $option->value }}</td>
                        <td>{{ $option->label }}</td>
                        <td>
                            <span class="badge bg-{{ $option->active ? 'success' : 'danger' }}">
                                {{ $option->active ? 'Activo' : 'Inactivo' }}
                            </span>
                        </td>
                        <td>
                            <div class="btn-group" role="group">
                                <a href="{{ route('scanner-options.edit', $option) }}" class="btn btn-sm btn-outline-warning">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <form action="{{ route('scanner-options.destroy', $option) }}" method="POST" class="d-inline" onsubmit="return confirm('¿Estás seguro de eliminar esta opción?')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-outline-danger">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="5" class="text-center py-4">No hay opciones registradas.</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
    <div class="card-footer">
        {{ $options->withQueryString()->links() }}
    </div>
</div>
@endsection
