<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Editar Cliente - {{ $client->client_name }}</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f8f9fa;
        }
        .card {
            box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
        }
        .form-control {
            border: 1px solid #ced4da;
            border-radius: 4px;
            padding: 10px;
            font-size: 0.9em;
            transition: border-color 0.2s, box-shadow 0.2s;
        }
        .form-control:focus {
            border-color: #3498db;
            outline: none;
            box-shadow: 0 0 0 2px rgba(52, 152, 219, 0.2);
        }
        .text-danger {
            font-size: 0.8em;
            margin-top: 5px;
        }
        .gap-2 {
            gap: 10px;
        }
        .btn-danger {
            background-color: #dc3545;
            color: white;
            border: none;
        }
        .btn-danger:hover {
            background-color: #c82333;
        }
    </style>
</head>
<body>
    <div class="container-fluid py-4">
        <div class="row">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h2><i class="fas fa-edit text-primary"></i> Editar Cliente</h2>
                    <div class="d-flex gap-2">
                        <a href="/test/clients" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Volver a Lista
                        </a>
                        <span class="badge bg-info fs-6">ID: {{ $client->id }}</span>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-8">
                        <div class="card">
                            <div class="card-header">
                                <h5 class="mb-0"><i class="fas fa-edit"></i> Información del Cliente</h5>
                            </div>
                            <div class="card-body">
                                <form method="POST" action="#" id="clientForm">
                                    @csrf
                                    @method('PUT')
                                    
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label for="client_name" class="form-label">Nombre de la Empresa *</label>
                                                <input type="text" class="form-control" id="client_name" name="client_name" 
                                                       value="{{ $client->client_name }}" required>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label for="contact_person" class="form-label">Persona de Contacto *</label>
                                                <input type="text" class="form-control" id="contact_person" name="contact_person" 
                                                       value="{{ $client->contact_person }}" required>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label for="email" class="form-label">Email *</label>
                                                <input type="email" class="form-control" id="email" name="email" 
                                                       value="{{ $client->email }}" required>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label for="phone" class="form-label">Teléfono</label>
                                                <input type="text" class="form-control" id="phone" name="phone" 
                                                       value="{{ $client->phone }}">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group mb-3">
                                        <label for="address" class="form-label">Dirección</label>
                                        <textarea class="form-control" id="address" name="address" rows="2">{{ $client->address }}</textarea>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label for="is_active" class="form-label">Estado *</label>
                                                <select class="form-control" id="is_active" name="is_active" required>
                                                    <option value="">Seleccionar estado</option>
                                                    <option value="1" {{ $client->is_active == 1 ? 'selected' : '' }}>Activo</option>
                                                    <option value="0" {{ $client->is_active == 0 ? 'selected' : '' }}>Inactivo</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group mb-3">
                                        <label for="notes" class="form-label">Notas</label>
                                        <textarea class="form-control" id="notes" name="notes" rows="3">{{ $client->notes }}</textarea>
                                    </div>

                                    <div class="d-flex justify-content-end gap-2">
                                        <a href="/test/clients" class="btn btn-secondary">
                                            <i class="fas fa-times"></i> Cancelar
                                        </a>
                                        <button type="button" class="btn btn-primary" onclick="saveClient()">
                                            <i class="fas fa-save"></i> Actualizar Cliente
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="card">
                            <div class="card-header">
                                <h5 class="mb-0"><i class="fas fa-info-circle"></i> Información del Cliente</h5>
                            </div>
                            <div class="card-body">
                                <p><strong>ID:</strong> {{ $client->id }}</p>
                                <p><strong>Estado:</strong> 
                                    @if($client->is_active)
                                        <span class="badge bg-success">Activo</span>
                                    @else
                                        <span class="badge bg-danger">Inactivo</span>
                                    @endif
                                </p>
                                <p><strong>Creado:</strong> {{ $client->created_at->format('d/m/Y H:i') }}</p>
                                <p><strong>Actualizado:</strong> {{ $client->updated_at->format('d/m/Y H:i') }}</p>
                            </div>
                        </div>

                        <div class="card mt-3">
                            <div class="card-header">
                                <h5 class="mb-0"><i class="fas fa-eye"></i> Vista Previa</h5>
                            </div>
                            <div class="card-body">
                                <div class="border rounded p-3 bg-light">
                                    <h6 class="fw-bold">{{ $client->client_name }}</h6>
                                    <p class="mb-1"><strong>Contacto:</strong> {{ $client->contact_person }}</p>
                                    <p class="mb-1"><strong>Email:</strong> {{ $client->email }}</p>
                                    <p class="mb-1"><strong>Teléfono:</strong> {{ $client->phone ?: 'No especificado' }}</p>
                                    @if($client->address)
                                        <p class="mb-1"><strong>Dirección:</strong> {{ Str::limit($client->address, 50) }}</p>
                                    @endif
                                    @if($client->notes)
                                        <p class="mb-0"><strong>Notas:</strong> {{ Str::limit($client->notes, 30) }}</p>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Auto-focus en el primer campo
        document.addEventListener('DOMContentLoaded', function() {
            document.getElementById('client_name').focus();
        });

        function saveClient() {
            // En una implementación real, aquí harías la llamada AJAX para guardar
            alert('Funcionalidad de guardado implementada en la versión completa del sistema.\n\nLos datos del formulario están listos para ser enviados.');
            
            // Mostrar los datos que se enviarían
            const formData = new FormData(document.getElementById('clientForm'));
            console.log('Datos del formulario:', Object.fromEntries(formData));
        }

        // Actualizar vista previa en tiempo real
        document.addEventListener('input', function(e) {
            if (e.target.matches('input, textarea, select')) {
                updatePreview();
            }
        });

        function updatePreview() {
            const clientName = document.getElementById('client_name').value;
            const contactPerson = document.getElementById('contact_person').value;
            const email = document.getElementById('email').value;
            const phone = document.getElementById('phone').value;
            const address = document.getElementById('address').value;
            const notes = document.getElementById('notes').value;
            const isActive = document.getElementById('is_active').value;

            // Actualizar vista previa (simplificada)
            console.log('Vista previa actualizada:', {
                client_name: clientName,
                contact_person: contactPerson,
                email: email,
                phone: phone,
                address: address,
                notes: notes,
                is_active: isActive
            });
        }
    </script>
</body>
</html>
