<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Editar Reetiquetado - {{ $relabeling->proveedor_code }}</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body { background-color: #f8f9fa; }
        .card { box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075); }
        .form-control { border: 1px solid #ced4da; border-radius: 4px; padding: 10px; font-size: 0.9em; }
        .form-control:focus { border-color: #3498db; outline: none; box-shadow: 0 0 0 2px rgba(52, 152, 219, 0.2); }
    </style>
</head>
<body>
    <div class="container-fluid py-4">
        <div class="row">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h2><i class="fas fa-edit text-primary"></i> Editar Producto de Reetiquetado</h2>
                    <div class="d-flex gap-2">
                        <a href="/test/clients" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Volver
                        </a>
                        <span class="badge bg-info fs-6">Código: {{ $relabeling->proveedor_code }}</span>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-8">
                        <div class="card">
                            <div class="card-header">
                                <h5 class="mb-0"><i class="fas fa-edit"></i> Información del Producto</h5>
                            </div>
                            <div class="card-body">
                                <form method="POST" action="#" id="relabelingForm">
                                    @csrf
                                    @method('PUT')
                                    
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label for="proveedor_code" class="form-label">Código Proveedor *</label>
                                                <input type="text" class="form-control" id="proveedor_code" name="proveedor_code" 
                                                       value="{{ $relabeling->proveedor_code }}" required>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label for="codebar_gnu" class="form-label">Código Barras GNU *</label>
                                                <input type="text" class="form-control" id="codebar_gnu" name="codebar_gnu" 
                                                       value="{{ $relabeling->codebar_gnu }}" required>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group mb-3">
                                        <label for="description" class="form-label">Descripción *</label>
                                        <textarea class="form-control" id="description" name="description" rows="3" required>{{ $relabeling->description }}</textarea>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label for="price_cfa" class="form-label">Precio CFA</label>
                                                <input type="number" step="0.01" class="form-control" id="price_cfa" 
                                                       name="price_cfa" value="{{ $relabeling->price_cfa }}">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="d-flex justify-content-end gap-2">
                                        <a href="/test/clients" class="btn btn-secondary">
                                            <i class="fas fa-times"></i> Cancelar
                                        </a>
                                        <button type="button" class="btn btn-primary" onclick="saveRelabeling()">
                                            <i class="fas fa-save"></i> Actualizar Producto
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="card">
                            <div class="card-header">
                                <h5 class="mb-0"><i class="fas fa-info-circle"></i> Información</h5>
                            </div>
                            <div class="card-body">
                                <p class="text-muted">
                                    <strong>Campos obligatorios:</strong> Los campos marcados con (*) son obligatorios.
                                </p>
                                <p class="text-muted">
                                    <strong>Código Proveedor:</strong> {{ $relabeling->proveedor_code }}
                                </p>
                                <p class="text-muted">
                                    <strong>Código Barras GNU:</strong> {{ $relabeling->codebar_gnu }}
                                </p>
                                <p class="text-muted">
                                    <strong>Descripción:</strong> {{ Str::limit($relabeling->description, 50) }}
                                </p>
                                
                                <hr>
                                
                                <h6><i class="fas fa-history"></i> Información del Registro</h6>
                                <p class="text-muted small">
                                    <strong>Creado:</strong> {{ $relabeling->created_at->format('d/m/Y H:i') }}
                                </p>
                                <p class="text-muted small">
                                    <strong>Última actualización:</strong> {{ $relabeling->updated_at->format('d/m/Y H:i') }}
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            document.getElementById('proveedor_code').focus();
        });

        function saveRelabeling() {
            alert('Funcionalidad de guardado implementada en la versión completa del sistema.');
            const formData = new FormData(document.getElementById('relabelingForm'));
            console.log('Datos del formulario:', Object.fromEntries(formData));
        }
    </script>
</body>
</html>
