@extends('layouts.app')

@section('title', __('users.create'))

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-user-plus"></i> {{ __('users.create_new') }}</h2>
    <a href="{{ route('users.index') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> {{ __('users.back') }}
    </a>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5><i class="fas fa-edit"></i> {{ __('users.info.user_info') }}</h5>
            </div>
            <div class="card-body">
                <form method="POST" action="{{ route('users.store') }}">
                    @csrf
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="name">{{ __('users.fields.name') }} *</label>
                                <input type="text" class="form-control" id="name" name="name" 
                                       value="{{ old('name') }}" required>
                                @error('name')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="email">{{ __('users.fields.email') }} *</label>
                                <input type="email" class="form-control" id="email" name="email" 
                                       value="{{ old('email') }}" required>
                                @error('email')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="password">{{ __('users.fields.password') }} *</label>
                                <input type="password" class="form-control" id="password" name="password" required>
                                @error('password')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="password_confirmation">{{ __('users.fields.password_confirmation') }} *</label>
                                <input type="password" class="form-control" id="password_confirmation" 
                                       name="password_confirmation" required>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="operario_id">{{ __('users.fields.operario_id') }}</label>
                                <input type="text" class="form-control" id="operario_id" name="operario_id" 
                                       value="{{ old('operario_id') }}" placeholder="{{ __('users.fields.operario_id_placeholder') }}">
                                @error('operario_id')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="client_id">{{ __('users.fields.client_id') }}</label>
                                <select class="form-control" id="client_id" name="client_id">
                                    <option value="">{{ __('users.fields.no_client') }}</option>
                                    @foreach($clients as $client)
                                        <option value="{{ $client->id }}" {{ old('client_id') == $client->id ? 'selected' : '' }}>
                                            {{ $client->client_name }} ({{ $client->email ?? __('users.messages.no_email') }})
                                        </option>
                                    @endforeach
                                </select>
                                <small class="text-muted">{{ __('users.fields.client_note') }}</small>
                                @error('client_id')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="is_active">{{ __('users.fields.is_active') }}</label>
                                <select class="form-control" id="is_active" name="is_active">
                                    <option value="1" {{ old('is_active', true) ? 'selected' : '' }}>{{ __('users.status.active') }}</option>
                                    <option value="0" {{ !old('is_active', true) ? 'selected' : '' }}>{{ __('users.status.inactive') }}</option>
                                </select>
                                @error('is_active')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="roles">{{ __('users.fields.roles') }} *</label>
                        <select class="form-control" id="roles" name="roles[]" multiple required>
                            @foreach($roles as $role)
                                <option value="{{ $role->name }}" {{ in_array($role->name, old('roles', [])) ? 'selected' : '' }}>
                                    {{ ucfirst($role->name) }}
                                </option>
                            @endforeach
                        </select>
                        @error('roles')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                        <small class="text-muted">{{ __('users.fields.roles_multiple') }}</small>
                    </div>

                    <div class="d-flex justify-content-end gap-2">
                        <a href="{{ route('users.index') }}" class="btn btn-secondary">
                            <i class="fas fa-times"></i> {{ __('users.buttons.cancel') }}
                        </a>
                        <button type="submit" class="btn">
                            <i class="fas fa-save"></i> {{ __('users.buttons.create') }}
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5><i class="fas fa-info-circle"></i> {{ __('users.info.title') }}</h5>
            </div>
            <div class="card-body">
                <p class="text-muted">
                    <strong>{{ __('users.info.required_fields') }}</strong> {{ __('users.info.required_note') }}
                </p>
                <p class="text-muted">
                    <strong>{{ __('users.info.email_note') }}</strong> {{ __('users.info.email_description') }}
                </p>
                <p class="text-muted">
                    <strong>{{ __('users.info.password_note') }}</strong> {{ __('users.info.password_description') }}
                </p>
                <p class="text-muted">
                    <strong>{{ __('users.info.roles_note') }}</strong> {{ __('users.info.roles_description') }}
                </p>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
.form-control {
    border: 1px solid var(--sap-border-color);
    border-radius: 4px;
    padding: 10px;
    font-size: 0.9em;
    transition: border-color 0.2s, box-shadow 0.2s;
}

.form-control:focus {
    border-color: var(--sap-blue-light);
    outline: none;
    box-shadow: 0 0 0 2px rgba(52, 152, 219, 0.2);
}

.text-danger {
    font-size: 0.8em;
    margin-top: 5px;
}

.gap-2 {
    gap: 10px;
}
</style>
@endpush

