@extends('layouts.app')

@section('title', __('users.title'))

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-users"></i> {{ __('users.title') }}</h2>
    <a href="{{ route('users.create') }}" class="btn">
        <i class="fas fa-plus"></i> {{ __('users.new') }}
    </a>
</div>

<!-- Filtros -->
<div class="card mb-4">
    <div class="card-header">
        <h5><i class="fas fa-filter"></i> {{ __('users.filters.title') }}</h5>
    </div>
    <div class="card-body">
        <form method="GET" action="{{ route('users.index') }}" class="row g-3">
            <div class="col-md-3">
                <label for="search" class="form-label">{{ __('users.filters.search') }}</label>
                <input type="text" class="form-control" id="search" name="search"
                    value="{{ request('search') }}" placeholder="{{ __('users.filters.search_placeholder') }}">
            </div>
            <div class="col-md-3">
                <label for="role" class="form-label">{{ __('users.filters.role') }}</label>
                <select class="form-control" id="role" name="role">
                    <option value="">{{ __('users.filters.all_roles') }}</option>
                    @foreach($roles as $role)
                    <option value="{{ $role->name }}" {{ request('role') === $role->name ? 'selected' : '' }}>
                        {{ ucfirst($role->name) }}
                    </option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-3">
                <label for="is_active" class="form-label">{{ __('users.filters.status') }}</label>
                <select class="form-control" id="is_active" name="is_active">
                    <option value="">{{ __('users.filters.all') }}</option>
                    <option value="1" {{ request('is_active') === '1' ? 'selected' : '' }}>{{ __('users.filters.active') }}</option>
                    <option value="0" {{ request('is_active') === '0' ? 'selected' : '' }}>{{ __('users.filters.inactive') }}</option>
                </select>
            </div>
            <div class="col-md-3">
                <label class="form-label">&nbsp;</label>
                <div class="d-flex gap-2">
                    <button type="submit" class="btn">
                        <i class="fas fa-search"></i> {{ __('users.filters.apply') }}
                    </button>
                    <a href="{{ route('users.index') }}" class="btn btn-secondary">
                        <i class="fas fa-times"></i> {{ __('users.filters.clear') }}
                    </a>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Controles de Paginación -->
@if($users->total() > 0 || $users->hasPages())
<div class="card mb-3">
    <div class="card-body">
        <form method="GET" action="{{ route('users.index') }}" id="pagination-form" class="d-flex justify-content-between align-items-center flex-wrap gap-3">
            <!-- Mantener filtros en campos ocultos -->
            @if(request('search'))
            <input type="hidden" name="search" value="{{ request('search') }}">
            @endif
            @if(request('role'))
            <input type="hidden" name="role" value="{{ request('role') }}">
            @endif
            @if(request('is_active'))
            <input type="hidden" name="is_active" value="{{ request('is_active') }}">
            @endif

            <div class="d-flex align-items-center gap-2">
                <label for="per_page">{{ __('users.pagination.rows_per_page') }}</label>
                <select name="per_page" id="per_page" class="form-control" style="width: auto;" onchange="this.form.submit()">
                    <option value="10" {{ request('per_page', 20) == 10 ? 'selected' : '' }}>10</option>
                    <option value="25" {{ request('per_page', 20) == 25 ? 'selected' : '' }}>25</option>
                    <option value="50" {{ request('per_page', 20) == 50 ? 'selected' : '' }}>50</option>
                    <option value="100" {{ request('per_page', 20) == 100 ? 'selected' : '' }}>100</option>
                    <option value="250" {{ request('per_page', 20) == 250 ? 'selected' : '' }}>250</option>
                </select>
            </div>
            <div class="text-muted">
                {{ __('users.pagination.page_info', [
                    'current' => $users->currentPage(),
                    'total' => $users->lastPage(),
                    'records' => $users->total()
                ]) }}
            </div>
            <div class="d-flex align-items-center gap-2">
                @if($users->onFirstPage())
                <button type="button" class="btn btn-sm" disabled>{{ __('users.pagination.previous') }}</button>
                @else
                <a href="{{ $users->previousPageUrl() }}" class="btn btn-sm">{{ __('users.pagination.previous') }}</a>
                @endif

                @foreach($users->getUrlRange(max(1, $users->currentPage() - 2), min($users->lastPage(), $users->currentPage() + 2)) as $page => $url)
                @if($page == $users->currentPage())
                <span class="pagination-link active">{{ $page }}</span>
                @else
                <a href="{{ $url }}" class="pagination-link">{{ $page }}</a>
                @endif
                @endforeach

                @if($users->hasMorePages())
                <a href="{{ $users->nextPageUrl() }}" class="btn btn-sm">{{ __('users.pagination.next') }}</a>
                @else
                <button type="button" class="btn btn-sm" disabled>{{ __('users.pagination.next') }}</button>
                @endif
            </div>
        </form>
    </div>
</div>
@endif

<!-- Tabla de Usuarios -->
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5><i class="fas fa-list"></i> {{ __('users.table.title') }}</h5>
        <span class="badge bg-primary">{{ $users->total() }} {{ __('users.table.total') }}</span>
    </div>
    <div class="card-body p-0">
        @if($users->count() > 0)
        <div class="table-responsive">
            <table class="data-table">
                <thead>
                    <tr>
                        <th>{{ __('users.table.id') }}</th>
                        <th>{{ __('users.table.name') }}</th>
                        <th>{{ __('users.table.email') }}</th>
                        <th>{{ __('users.table.operario_id') }}</th>
                        <th>{{ __('users.table.roles') }}</th>
                        <th>{{ __('users.table.status') }}</th>
                        <th>{{ __('users.table.actions') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($users as $user)
                    <tr>
                        <td>{{ $user->id }}</td>
                        <td>{{ $user->name }}</td>
                        <td>{{ $user->email }}</td>
                        <td>{{ $user->operario_id ?? '-' }}</td>
                        <td>
                            @foreach($user->roles as $role)
                            <span class="badge badge-info">{{ ucfirst($role->name) }}</span>
                            @endforeach
                        </td>
                        <td>
                            <span class="badge badge-{{ $user->is_active ? 'success' : 'danger' }}">
                                {{ $user->is_active ? __('users.status.active') : __('users.status.inactive') }}
                            </span>
                        </td>
                        <td>
                            <div class="btn-group" role="group">
                                <a href="{{ route('users.show', $user) }}" class="btn btn-sm btn-outline-info">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <a href="{{ route('users.edit', $user) }}" class="btn btn-sm btn-outline-warning">
                                    <i class="fas fa-edit"></i>
                                </a>
                                @if($user->id !== auth()->id())
                                <form action="{{ route('users.destroy', $user) }}" method="POST"
                                    class="d-inline" onsubmit="return confirm('{{ __('users.messages.delete_confirm') }}')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-outline-danger">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                                @endif
                            </div>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        @else
        <div class="text-center py-5">
            <i class="fas fa-users fa-3x text-muted mb-3"></i>
            <h5 class="text-muted">{{ __('users.table.no_users') }}</h5>
            <p class="text-muted">{{ __('users.table.no_users_message') }}</p>
            <a href="{{ route('users.create') }}" class="btn">
                <i class="fas fa-plus"></i> {{ __('users.table.create_first') }}
            </a>
        </div>
        @endif
    </div>
</div>
@endsection

@push('styles')
<style>
    .btn-group {
        display: flex;
        gap: 5px;
    }

    .btn-sm {
        padding: 5px 10px;
        font-size: 0.8em;
        min-width: auto;
    }

    .btn-outline-info {
        background-color: transparent;
        color: #17a2b8;
        border: 1px solid #17a2b8;
    }

    .btn-outline-info:hover {
        background-color: #17a2b8;
        color: white;
    }

    .btn-outline-warning {
        background-color: transparent;
        color: #ffc107;
        border: 1px solid #ffc107;
    }

    .btn-outline-warning:hover {
        background-color: #ffc107;
        color: white;
    }

    .btn-outline-danger {
        background-color: transparent;
        color: #dc3545;
        border: 1px solid #dc3545;
    }

    .btn-outline-danger:hover {
        background-color: #dc3545;
        color: white;
    }

    .badge {
        padding: 4px 8px;
        font-size: 0.75em;
        font-weight: 500;
        border-radius: 4px;
    }

    .bg-primary {
        background-color: var(--sap-blue-light) !important;
    }

    .badge-info {
        background-color: #17a2b8;
        color: white;
    }

    .badge-success {
        background-color: #28a745;
        color: white;
    }

    .badge-danger {
        background-color: #dc3545;
        color: white;
    }


    .gap-2 {
        gap: 10px;
    }

    .pagination-link {
        padding: 5px 10px;
        margin: 0 2px;
        border: 1px solid #007bff;
        border-radius: 3px;
        text-decoration: none;
        color: #007bff;
        cursor: pointer;
        font-size: 14px;
        display: inline-block;
    }

    .pagination-link:hover:not(.active) {
        background-color: #e6f2ff;
    }

    .pagination-link.active {
        background-color: #007bff;
        color: white;
        pointer-events: none;
    }
</style>
@endpush
