<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ScannerController;
use App\Http\Controllers\InventoryController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\OrderPreparationController;

// Authentication Routes
Route::post('/login', [AuthController::class, 'login']);
Route::post('/logout', [AuthController::class, 'logout']);

// Protected API Routes
Route::middleware(['web', 'auth', 'api'])->group(function () {
    // Scanner Routes
    Route::post('/scanner/search-article', [ScannerController::class, 'searchArticle']);
    Route::post('/scanner/process-scan', [ScannerController::class, 'processScan']);
    Route::post('/scanner/get-box-content', [ScannerController::class, 'getBoxContent']);
    Route::post('/scanner/create-article', [ScannerController::class, 'createArticle']);
    
    // Inventory Routes
    Route::post('/inventory/search', [InventoryController::class, 'search']);
    Route::put('/inventory/update', [InventoryController::class, 'updateField']);
    Route::delete('/inventory/delete', [InventoryController::class, 'destroy']);
    Route::get('/inventory/statistics', [InventoryController::class, 'statistics']);
    Route::post('/inventory/export', [InventoryController::class, 'export']);
    
    // Order Preparation API Routes
    Route::get('/order-preparation/clients', [OrderPreparationController::class, 'getClients']);
    Route::post('/order-preparation/save-draft', [OrderPreparationController::class, 'saveDraft']);
    Route::get('/order-preparation/draft-orders', [OrderPreparationController::class, 'getDraftOrders']);
    Route::post('/order-preparation/confirm-dispatch', [OrderPreparationController::class, 'confirmDispatch']);
    Route::get('/order-preparation/client-orders/{clientId}', [OrderPreparationController::class, 'getClientOrders']);
    
    // User info
    Route::get('/me', function (Request $request) {
        return $request->user();
    });
});