<?php $__env->startSection('title', __('orders.details')); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-shopping-cart"></i> <?php echo e(__('orders.show.title', ['id' => $order->id])); ?></h2>
    <a href="<?php echo e(route('orders.index')); ?>" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> <?php echo e(__('orders.buttons.back')); ?>

    </a>
</div>

<?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(session('error')): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <i class="fas fa-exclamation-circle"></i> <?php echo e(session('error')); ?>

        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
<?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

<?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(session('success')): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="fas fa-check-circle"></i> <?php echo e(session('success')); ?>

        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
<?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

<div class="row">
    <!-- Información General del Pedido -->
    <div class="col-md-8">
        <div class="card mb-4">
            <div class="card-header">
                <h5><i class="fas fa-info-circle"></i> <?php echo e(__('orders.show.general_info')); ?></h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <p><strong><?php echo e(__('orders.show.order_id')); ?>:</strong> <?php echo e($order->id); ?></p>
                        <p><strong><?php echo e(__('orders.show.client')); ?>:</strong> <?php echo e($order->client->client_name ?? 'N/A'); ?></p>
                        <p><strong><?php echo e(__('orders.show.email')); ?>:</strong> <?php echo e($order->client->email ?? 'N/A'); ?></p>
                        <p><strong><?php echo e(__('orders.show.phone')); ?>:</strong> <?php echo e($order->client->phone ?? 'N/A'); ?></p>
                    </div>
                    <div class="col-md-6">
                        <p><strong><?php echo e(__('orders.show.status')); ?>:</strong> 
                            <?php
                                $statusClasses = [
                                    'dispatched' => 'success',
                                    'cancelled' => 'danger',
                                    'pending' => 'primary',
                                    'reserved' => 'info',
                                    'draft' => 'warning',
                                ];
                                $statusClass = $statusClasses[$order->status] ?? 'secondary';
                                $statusTranslations = [
                                    'draft' => __('orders.status.draft'),
                                    'reserved' => __('orders.status.reserved'),
                                    'pending' => __('orders.status.pending'),
                                    'dispatched' => __('orders.status.dispatched'),
                                    'cancelled' => __('orders.status.cancelled'),
                                ];
                                $statusText = $statusTranslations[$order->status] ?? ucfirst($order->status);
                            ?>
                            <span class="badge badge-<?php echo e($statusClass); ?>">
                                <?php echo e($statusText); ?>

                            </span>
                        </p>
                        <p><strong><?php echo e(__('orders.show.operator')); ?>:</strong> <?php echo e($order->operario_id ?? 'N/A'); ?></p>
                        <p><strong><?php echo e(__('orders.show.order_date')); ?>:</strong> <?php echo e($order->created_at->format('d/m/Y H:i')); ?></p>
                        <p><strong><?php echo e(__('orders.show.dispatch_date')); ?>:</strong> <?php echo e($order->dispatched_date ? $order->dispatched_date->format('d/m/Y H:i') : 'N/A'); ?></p>
                    </div>
                </div>
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($order->notes): ?>
                    <div class="mt-3">
                        <strong><?php echo e(__('orders.show.notes')); ?>:</strong>
                        <p><?php echo e($order->notes); ?></p>
                    </div>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </div>
        </div>

        <!-- Artículos del Pedido -->
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5><i class="fas fa-boxes"></i> <?php echo e(__('orders.show.items_count', ['count' => $order->orderItems->count()])); ?></h5>
            </div>
            <div class="card-body p-0">
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($order->orderItems->count() > 0): ?>
                    <div class="table-responsive">
                        <table class="data-table">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('orders.show.barcode')); ?></th>
                                    <th><?php echo e(__('orders.show.mocaco')); ?></th>
                                    <th><?php echo e(__('orders.show.box_number')); ?></th>
                                    <th><?php echo e(__('orders.show.location')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $order->orderItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><code><?php echo e($item->full_barcode); ?></code></td>
                                        <td><?php echo e($item->mocaco ?? 'N/A'); ?></td>
                                        <td><?php echo e($item->n_carton ?? 'N/A'); ?></td>
                                        <td><?php echo e($item->ubicacion ?? 'N/A'); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <div class="text-center py-5">
                        <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                        <p class="text-muted"><?php echo e(__('orders.show.no_items')); ?></p>
                    </div>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Panel de Acciones -->
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5><i class="fas fa-cog"></i> <?php echo e(__('orders.show.actions')); ?></h5>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <a href="<?php echo e(route('orders.export-order', $order)); ?>" class="btn btn-info">
                        <i class="fas fa-file-excel"></i> <?php echo e(__('orders.show.download_order')); ?>

                    </a>
                    
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($order->url_pdf_factura): ?>
                        <a href="<?php echo e(route('orders.download-invoice', $order)); ?>" class="btn btn-success" target="_blank">
                            <i class="fas fa-file-pdf"></i> <?php echo e(__('orders.buttons.download_invoice')); ?>

                        </a>
                    <?php else: ?>
                        <button type="button" class="btn btn-secondary" disabled>
                            <i class="fas fa-file-pdf"></i> <?php echo e(__('orders.buttons.invoice_not_available')); ?>

                        </button>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($order->status === 'draft'): ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('orders.update')): ?>
                        <a href="<?php echo e(route('orders.edit', $order)); ?>" class="btn">
                            <i class="fas fa-edit"></i> <?php echo e(__('orders.buttons.edit')); ?>

                        </a>
                        <?php endif; ?>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($order->status !== 'dispatched' && $order->status !== 'cancelled'): ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('orders.delete')): ?>
                        <form action="<?php echo e(route('orders.destroy', $order)); ?>" method="POST" onsubmit="return confirm('<?php echo e(__('orders.show.delete_confirm')); ?>')">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="btn btn-danger w-100">
                                <i class="fas fa-trash"></i> <?php echo e(__('orders.buttons.delete')); ?>

                            </button>
                        </form>
                        <?php endif; ?>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </div>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h5><i class="fas fa-info-circle"></i> <?php echo e(__('orders.show.client_info')); ?></h5>
            </div>
            <div class="card-body">
                <p><strong><?php echo e(__('orders.show.client')); ?>:</strong> <?php echo e($order->client->client_name ?? 'N/A'); ?></p>
                <p><strong><?php echo e(__('orders.show.email')); ?>:</strong> <?php echo e($order->client->email ?? 'N/A'); ?></p>
                <p><strong><?php echo e(__('orders.show.phone')); ?>:</strong> <?php echo e($order->client->phone ?? 'N/A'); ?></p>
                <p><strong><?php echo e(__('orders.show.address')); ?>:</strong> <?php echo e($order->client->address ?? 'N/A'); ?></p>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
.btn-group {
    display: flex;
    gap: 5px;
}

.btn-sm {
    padding: 5px 10px;
    font-size: 0.8em;
    min-width: auto;
}

.badge {
    padding: 0.5em 0.75em;
    font-size: 0.75em;
    font-weight: 700;
    line-height: 1;
    text-align: center;
    white-space: nowrap;
    vertical-align: baseline;
    border-radius: 0.375rem;
}

.badge-success {
    background-color: #28a745;
    color: white;
}

.badge-warning {
    background-color: #ffc107;
    color: #212529;
}

.badge-danger {
    background-color: #dc3545;
    color: white;
}

code {
    font-family: 'Courier New', monospace;
    background-color: #f8f9fa;
    padding: 2px 4px;
    border-radius: 3px;
    font-size: 0.9em;
}

.gap-2 {
    gap: 10px;
}

.d-grid {
    display: grid;
}

.w-100 {
    width: 100%;
}
</style>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/inventory/inventory_new/resources/views/orders/show.blade.php ENDPATH**/ ?>