<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo $__env->yieldContent('title', __('app.html_title')); ?></title>

    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <!-- Vite Assets (includes Tailwind CSS) -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>

    <!-- Livewire Styles -->
    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::styles(); ?>

    <?php echo \Rappasoft\LaravelLivewireTables\Mechanisms\RappasoftFrontendAssets::tableStyles(); ?>

    <?php echo \Rappasoft\LaravelLivewireTables\Mechanisms\RappasoftFrontendAssets::tableThirdPartyStyles(); ?>


    <?php echo $__env->yieldPushContent('styles'); ?>
</head>

<body class="flex min-h-screen bg-[var(--color-sap-background-light)] text-[var(--color-sap-text-dark)] text-sm font-sans m-0">
    <!-- Sidebar -->
    <div class="w-64 bg-[var(--color-sap-blue-dark)] text-white py-6 shadow-[var(--shadow-sidebar)] flex flex-col items-center sticky top-0 h-screen overflow-y-auto">
        <h2 class="text-center text-gray-100 mb-10 text-2xl px-4 border-b border-white/10 pb-4 w-[calc(100%-30px)]">
            <i class="fas fa-warehouse"></i> <?php echo e(__('app.app_name')); ?>

        </h2>

        <ul class="list-none p-0 w-full">
            <li>
                <a href="<?php echo e(route('dashboard')); ?>"
                   class="sidebar-link <?php echo e(request()->routeIs('dashboard') ? 'sidebar-active' : ''); ?>">
                    <i class="fas fa-tachometer-alt mr-3 text-xl text-white/70"></i> <?php echo e(__('app.sidebar.dashboard')); ?>

                </a>
            </li>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('inventory.view')): ?>
                <li>
                    <a href="<?php echo e(route('inventory.index')); ?>"
                       class="sidebar-link <?php echo e(request()->routeIs('inventory.index') || (request()->routeIs('inventory.*') && !request()->routeIs('article-review.*') && !request()->routeIs('inventory.boxes-without-location')) ? 'sidebar-active' : ''); ?>">
                        <i class="fas fa-boxes mr-3 text-xl text-white/70"></i> <?php echo e(__('app.sidebar.inventory')); ?>

                    </a>
                </li>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('inventory.view')): ?>
                <li>
                    <a href="<?php echo e(route('article-review.index')); ?>"
                       class="sidebar-link <?php echo e(request()->routeIs('article-review.*') ? 'sidebar-active' : ''); ?>">
                        <i class="fas fa-clipboard-check mr-3 text-xl text-white/70"></i> Revisión de Artículos
                    </a>
                </li>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('inventory.view')): ?>
                <li>
                    <a href="<?php echo e(route('inventory.boxes-without-location')); ?>"
                       class="sidebar-link <?php echo e(request()->routeIs('inventory.boxes-without-location') ? 'sidebar-active' : ''); ?>">
                        <i class="fas fa-map-marker-slash mr-3 text-xl text-white/70"></i> Cajas Sin Ubicación
                    </a>
                </li>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('articles.view')): ?>
                <li>
                    <a href="<?php echo e(route('articles.index')); ?>"
                       class="sidebar-link <?php echo e(request()->routeIs('articles.*') ? 'sidebar-active' : ''); ?>">
                        <i class="fas fa-tags mr-3 text-xl text-white/70"></i> <?php echo e(__('app.sidebar.articles')); ?>

                    </a>
                </li>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('clients.view')): ?>
                <li>
                    <a href="<?php echo e(route('clients.index')); ?>"
                       class="sidebar-link <?php echo e(request()->routeIs('clients.*') ? 'sidebar-active' : ''); ?>">
                        <i class="fas fa-handshake mr-3 text-xl text-white/70"></i> <?php echo e(__('app.sidebar.clients')); ?>

                    </a>
                </li>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('orders.view')): ?>
                <li>
                    <a href="<?php echo e(route('orders.index')); ?>"
                       class="sidebar-link <?php echo e(request()->routeIs('orders.*') ? 'sidebar-active' : ''); ?>">
                        <i class="fas fa-shopping-cart mr-3 text-xl text-white/70"></i> <?php echo e(__('app.sidebar.orders')); ?>

                    </a>
                </li>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('reservations.view')): ?>
                <li>
                    <a href="<?php echo e(route('reservations.index')); ?>"
                       class="sidebar-link <?php echo e(request()->routeIs('reservations.*') ? 'sidebar-active' : ''); ?>">
                        <i class="fas fa-clipboard-list mr-3 text-xl text-white/70"></i> Reservas de Cajas
                    </a>
                </li>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('order-preparation.view')): ?>
                <li>
                    <a href="<?php echo e(route('order-preparation')); ?>"
                       class="sidebar-link <?php echo e(request()->routeIs('order-preparation.*') ? 'sidebar-active' : ''); ?>">
                        <i class="fas fa-shopping-cart mr-3 text-xl text-white/70"></i> <?php echo e(__('app.sidebar.order_preparation')); ?>

                    </a>
                </li>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('relabeling.view')): ?>
                <li>
                    <a href="<?php echo e(route('relabeling.index')); ?>"
                       class="sidebar-link <?php echo e(request()->routeIs('relabeling.*') ? 'sidebar-active' : ''); ?>">
                        <i class="fas fa-redo mr-3 text-xl text-white/70"></i> <?php echo e(__('app.sidebar.relabeling')); ?>

                    </a>
                </li>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('inventory.view')): ?>
                <li>
                    <a href="<?php echo e(route('container-entries.index')); ?>"
                       class="sidebar-link <?php echo e(request()->routeIs('container-entries.*') ? 'sidebar-active' : ''); ?>">
                        <i class="fas fa-truck mr-3 text-xl text-white/70"></i> <?php echo e(__('app.sidebar.container_entries')); ?>

                    </a>
                </li>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('inventory.scan')): ?>
                <li>
                    <a href="<?php echo e(route('scanner')); ?>"
                       class="sidebar-link <?php echo e(request()->routeIs('scanner') ? 'sidebar-active' : ''); ?>">
                        <i class="fas fa-barcode mr-3 text-xl text-white/70"></i> <?php echo e(__('app.sidebar.scanner')); ?>

                    </a>
                </li>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('scanner-options.view')): ?>
                <li>
                    <a href="<?php echo e(route('scanner-options.index')); ?>"
                       class="sidebar-link <?php echo e(request()->routeIs('scanner-options.*') ? 'sidebar-active' : ''); ?>">
                        <i class="fas fa-list mr-3 text-xl text-white/70"></i> Opciones Escáner
                    </a>
                </li>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('location.view')): ?>
                <li>
                    <a href="<?php echo e(route('location')); ?>"
                       class="sidebar-link <?php echo e(request()->routeIs('location') ? 'sidebar-active' : ''); ?>">
                        <i class="fas fa-map-marker-alt mr-3 text-xl text-white/70"></i> <?php echo e(__('app.sidebar.assign_location')); ?>

                    </a>
                </li>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('client-history.view')): ?>
                <li>
                    <a href="<?php echo e(route('client-history')); ?>"
                       class="sidebar-link <?php echo e(request()->routeIs('client-history') ? 'sidebar-active' : ''); ?>">
                        <i class="fas fa-history mr-3 text-xl text-white/70"></i> <?php echo e(__('app.sidebar.client_history')); ?>

                    </a>
                </li>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('reports.productivity.view')): ?>
                <li>
                    <a href="<?php echo e(route('reports.productivity')); ?>"
                       class="sidebar-link <?php echo e(request()->routeIs('reports.productivity*') ? 'sidebar-active' : ''); ?>">
                        <i class="fas fa-chart-bar mr-3 text-xl text-white/70"></i> <?php echo e(__('app.sidebar.productivity_reports')); ?>

                    </a>
                </li>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('reports.stock.view')): ?>
                <li>
                    <a href="<?php echo e(route('reports.stock-summary')); ?>"
                       class="sidebar-link <?php echo e(request()->routeIs('reports.stock-summary') ? 'sidebar-active' : ''); ?>">
                        <i class="fas fa-boxes mr-3 text-xl text-white/70"></i> <?php echo e(__('app.sidebar.stock_summary')); ?>

                    </a>
                </li>
            <?php endif; ?>

            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(Auth::check() && (Auth::user()->hasRole('client') || Auth::user()->client_id)): ?>
                <li>
                    <a href="<?php echo e(route('portal.index')); ?>"
                       class="sidebar-link <?php echo e(request()->routeIs('portal.*') ? 'sidebar-active' : ''); ?>">
                        <i class="fas fa-user-circle mr-3 text-xl text-white/70"></i> <?php echo e(__('app.sidebar.client_portal')); ?>

                    </a>
                </li>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('users.view')): ?>
                <li>
                    <a href="<?php echo e(route('users.index')); ?>"
                       class="sidebar-link <?php echo e(request()->routeIs('users.*') ? 'sidebar-active' : ''); ?>">
                        <i class="fas fa-users mr-3 text-xl text-white/70"></i> <?php echo e(__('app.sidebar.users')); ?>

                    </a>
                </li>
            <?php endif; ?>

            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if (\Illuminate\Support\Facades\Blade::check('role', 'admin')): ?>
                <li>
                    <a href="<?php echo e(route('roles.index')); ?>"
                       class="sidebar-link <?php echo e(request()->routeIs('roles.*') ? 'sidebar-active' : ''); ?>">
                        <i class="fas fa-user-tag mr-3 text-xl text-white/70"></i> <?php echo e(__('app.sidebar.roles')); ?>

                    </a>
                </li>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(auth()->guard()->check()): ?>
                <li>
                    <a href="<?php echo e(route('logout')); ?>"
                       onclick="event.preventDefault(); document.getElementById('logout-form').submit();"
                       class="sidebar-link">
                        <i class="fas fa-sign-out-alt mr-3 text-xl text-white/70"></i> <?php echo e(__('app.auth.logout')); ?>

                    </a>
                </li>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if (\Illuminate\Support\Facades\Blade::check('role', 'admin')): ?>
                <li>
                    <a href="<?php echo e(route('config.index')); ?>"
                       class="sidebar-link <?php echo e(request()->routeIs('config.*') ? 'sidebar-active' : ''); ?>">
                        <i class="fas fa-cog mr-3 text-xl text-white/70"></i> <?php echo e(__('app.sidebar.config')); ?>

                    </a>
                </li>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </ul>
    </div>

    <!-- Main Content Area -->
    <div class="flex-1 p-8 bg-white m-5 rounded-lg shadow-[var(--shadow-light)] overflow-y-auto">
        <?php
            $currentLocale = app()->getLocale();
            $languageOptions = [
                'es' => ['flag' => '🇪🇸', 'label' => __('app.language.spanish')],
                'en' => ['flag' => '🇺🇸', 'label' => __('app.language.english')],
                'fr' => ['flag' => '🇫🇷', 'label' => __('app.language.french')],
            ];
        ?>

        <!-- Topbar with Language Selector -->
        <div class="flex justify-end items-center mb-4">
            <div class="relative inline-block text-left">
                <button type="button"
                        class="inline-flex items-center gap-2 bg-white text-[var(--color-sap-text-dark)] border border-[var(--color-sap-border)] rounded-full px-4 py-1.5 text-sm hover:bg-gray-50 transition-colors"
                        onclick="this.nextElementSibling.classList.toggle('hidden')">
                    <span class="text-lg leading-none"><?php echo e($languageOptions[$currentLocale]['flag'] ?? '🌐'); ?></span>
                    <?php echo e($languageOptions[$currentLocale]['label'] ?? strtoupper($currentLocale)); ?>

                    <i class="fas fa-chevron-down text-xs"></i>
                </button>
                <div class="hidden absolute right-0 mt-2 w-56 rounded-md shadow-lg bg-white ring-1 ring-black ring-opacity-5 z-10">
                    <div class="py-1">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $languageOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $locale => $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <form method="POST" action="<?php echo e(route('language.switch')); ?>">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="locale" value="<?php echo e($locale); ?>">
                                <button type="submit"
                                        class="w-full text-left px-4 py-2 text-sm hover:bg-gray-100 flex items-center justify-between <?php echo e($locale === $currentLocale ? 'bg-[var(--color-sap-blue-light)] text-white hover:bg-[var(--color-sap-blue-hover)]' : 'text-gray-700'); ?>">
                                    <span>
                                        <span class="text-lg mr-2"><?php echo e($option['flag']); ?></span>
                                        <?php echo e($option['label']); ?>

                                    </span>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($locale === $currentLocale): ?>
                                        <i class="fas fa-check text-green-500"></i>
                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </button>
                            </form>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Flash Messages -->
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(session('success')): ?>
            <div class="mb-4 p-3 bg-green-50 border border-green-200 text-green-800 rounded-md flex items-center">
                <i class="fas fa-check-circle mr-2"></i>
                <span><?php echo e(session('success')); ?></span>
            </div>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(session('error')): ?>
            <div class="mb-4 p-3 bg-red-50 border border-red-200 text-red-800 rounded-md flex items-center">
                <i class="fas fa-exclamation-circle mr-2"></i>
                <span><?php echo e(session('error')); ?></span>
            </div>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($errors->any()): ?>
            <div class="mb-4 p-3 bg-red-50 border border-red-200 text-red-800 rounded-md">
                <i class="fas fa-exclamation-triangle mr-2"></i>
                <ul class="m-0 pl-5">
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </ul>
            </div>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

        <!-- Page Content -->
        <?php echo e($slot); ?>

    </div>

    <!-- Logout Form -->
    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(auth()->guard()->check()): ?>
        <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="hidden">
            <?php echo csrf_field(); ?>
        </form>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

    <!-- JavaScript Libraries -->
    <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>

    <!-- CSRF Token for AJAX -->
    <script>
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        // Close dropdown when clicking outside
        document.addEventListener('click', function(event) {
            const dropdowns = document.querySelectorAll('.relative.inline-block');
            dropdowns.forEach(dropdown => {
                const button = dropdown.querySelector('button');
                const menu = dropdown.querySelector('div[class*="hidden"]');
                if (menu && !dropdown.contains(event.target)) {
                    menu.classList.add('hidden');
                }
            });
        });
    </script>

    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::scripts(); ?>

    <?php echo \Rappasoft\LaravelLivewireTables\Mechanisms\RappasoftFrontendAssets::tableScripts(); ?>

    <?php echo \Rappasoft\LaravelLivewireTables\Mechanisms\RappasoftFrontendAssets::tableThirdPartyScripts(); ?>

    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>

</html>
<?php /**PATH /var/www/inventory/inventory_new/resources/views/components/layouts/app.blade.php ENDPATH**/ ?>